//#include "stdafx.h"
#include <windows.h>
#include <stdlib.h>
//#include <conio.h>
#include <string.h>
//#include <process.h>
#include <stdio.h>

#ifdef _WIN32_WCE  //Provided for WinCon
	#include "UARTCE.h"
	#include "I7000CE.h"
	#define strnset _strnset

#else  //Provided for PC (Microsoft OS)
	#ifdef __cplusplus
		#define Exp87K extern "C" __declspec(dllexport)
	#else
		#define Exp87K __declspec(dllexport)
	#endif

	#include "uart.h"
	#include "i87000.h"
#endif

// ASCII characters that receive special processing
#define ASCII_BEL  0x07
#define ASCII_BS   0x08
#define ASCII_TAB  0x09
#define ASCII_LF   0x0A
#define ASCII_CR   0x0D
#define ASCII_XON  0x11
#define ASCII_XOFF 0x13

static int cLoop=0;
static char szCmd8K[80], szRec8K[80];

extern char HexToAscii(WORD hex);
extern char AsciiToHex(char cASCII);






WORD CALLBACK AnalogIn_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
  char   wPort,wFlag,cc[80],c1,c2;
  WORD   wAddr,wRetVal,i,j,wChannel,wCheckSum,wT,wTimeOut;
  WORD   wSlot;
  DWORD  dwID;

  //---------------------- input -------------------------------------
  wPort=(char)dwBuf[0];     // RS-232 port number: 1/2/3/4/..../255
  wAddr=(WORD)dwBuf[1];     // module address: 0x00 to 0xFF
  dwID=dwBuf[2];            // module ID: 0x87013/17/18/33
  wCheckSum=(WORD)dwBuf[3]; // checksum: 0=disable, 1=enable
  wTimeOut=(WORD)dwBuf[4];  // TimeOut constant: normal=100
  wChannel=(char)dwBuf[5];  // channel number for multi-channel 
  wFlag=(char)dwBuf[6];     // flag: 0=no save, 1=save send/receive string
  wSlot=(WORD)dwBuf[7];     // Slot Number
  //---------------------- output ------------------------------------
                        // fBuf[0]=analog input value

   switch (dwID)
   {

       case 0x87013 :  if( wChannel>3 )  return(AdChannelError);
		              szCmd8K[0]='#';
		          break;	
	   
       case 0x87017 :  if( wChannel>7 )  return(AdChannelError);
		              szCmd8K[0]='#';
		          break;
	   
       case 0x87018 :  if( wChannel>7 )  return(AdChannelError);//  11/06/2002 by sean
		              szCmd8K[0]='#';
		          break;  
		             
       case 0x87019 :  if( wChannel>7 )  return(AdChannelError);//  11/06/2002 by sean
		              szCmd8K[0]='#';
		          break;  
		                  
       case 0x87033 :  if( wChannel>3 )  return(AdChannelError);
		              szCmd8K[0]='$';
		          break;
	   case 0x87015 : if( wChannel>6 )  return(AdChannelError);
	                  szCmd8K[0]='#';
		          break; 
	   case 0x87016 : if( wChannel>1 )  return(AdChannelError);
	                  szCmd8K[0]='#';
		          break; 		          
       default: return(ModuleIdError);
   }


   //if (wChannel>7) return(AdChannelError);
   
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   szCmd8K[3]=(char)(wChannel+0x30);
   szCmd8K[4]=0;

  if(wFlag==1)
  {
    strcpy(szSend,szCmd8K);
    szReceive[0]=0;
  }
  wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
  if (wFlag==1)       strcpy(szReceive,szRec8K);

  fBuf[0]=(float)0.0;
  if (wRetVal != NoError) return wRetVal;

  if(szRec8K[0] != '>')   return ResultStrCheckError;


     i=1; j=0;
     while (szRec8K[i])
     {
        cc[j++]=szRec8K[i++];
     }
     cc[j]=0;

     if( wCheckSum )  // checksum enable
        cc[j-2]=0;

     fBuf[0]=(float)atof(cc);

	 //move to here 04/09/16
	if(strlen(szRec8K)==6)	//Total length is 6 bytes   //2003/4/4 by sean
	{
		if( !memcmp(szRec8K,">-0000",6) )  return UnderInputRange;
		if( !memcmp(szRec8K,">+9999",6) )  return ExceedInputRange;
	}

     return(NoError);
}



/* -------------------------------------------------------------------- */
WORD CALLBACK AnalogInHex_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
  char   wPort,wFlag,c1,c2;
  WORD   wAddr,wRetVal,wChannel,wCheckSum,wT,wTimeOut;
//  WORD   wRecStrLen;
  WORD   wSlot;
  DWORD  dwID;
  WORD   A,B,C,D;

  //---------------------- input -------------------------------------
  wPort=(char)dwBuf[0];     // RS-232 port number: 1/2/3/4/..../255
  wAddr=(WORD)dwBuf[1];     // module address: 0x00 to 0xFF
  dwID=dwBuf[2];            // module ID: 0x87017/0x87018
  wCheckSum=(WORD)dwBuf[3]; // checksum: 0=disable, 1=enable
  wTimeOut=(WORD)dwBuf[4];  // TimeOut constant: normal=100
  wChannel=(WORD)dwBuf[5];  // channel number for multi-channel
  wFlag=(char)dwBuf[6];     // flag: 0=no save, 1=save send/receive string
  wSlot=(WORD)dwBuf[7];     // Slot Number
  //---------------------- output ------------------------------------
                        // fBuf[0]=analog input value

   switch (dwID)
   {
       
       case 0x87013 :  if( wChannel>3 )  return(AdChannelError);
		          break;	
	   
       case 0x87017 :  if( wChannel>7 )  return(AdChannelError);
		          break;
	   
       case 0x87018 :  if( wChannel>7 )  return(AdChannelError); //  11/06/2002 by sean
		          break;
       default: return(ModuleIdError);
   }


   if (wChannel>7) return(AdChannelError);
   szCmd8K[0]='#';
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   szCmd8K[3]=wChannel+'0';
   szCmd8K[4]=0;

  if(wFlag==1)
  {
    strcpy(szSend,szCmd8K);
    szReceive[0]=0;
  }
  wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
  if (wFlag==1)       strcpy(szReceive,szRec8K);

  fBuf[0]=(float)0.0;
  if (wRetVal != NoError) return wRetVal;

  if(szRec8K[0] != '>')   return ResultStrCheckError;

//  if(wCheckSum==0) wRecStrLen=5; else wRecStrLen=7;

//   if ( strlen(szRec8K)!=wRecStrLen ) return ResultStrCheckError;

   A=AsciiToHex(szRec8K[1]);
   B=AsciiToHex(szRec8K[2]);
   C=AsciiToHex(szRec8K[3]);
   D=AsciiToHex(szRec8K[4]);
   dwBuf[7]=D+C*16+B*256+A*4096;

   // modify by martin 04/09/16
  if(strlen(szRec8K)==6)	
  {
	if( !memcmp(szRec8K,">-0000",6) ) 
	{
		A=AsciiToHex(szRec8K[2]);
		B=AsciiToHex(szRec8K[3]);
		C=AsciiToHex(szRec8K[4]);
		D=AsciiToHex(szRec8K[5]);
		dwBuf[7]=D+C*16+B*256+A*4096;
		return UnderInputRange;
	}
	if( !memcmp(szRec8K,">+9999",6) )  
	{
		A=AsciiToHex(szRec8K[2]);
		B=AsciiToHex(szRec8K[3]);
		C=AsciiToHex(szRec8K[4]);
		D=AsciiToHex(szRec8K[5]);
		dwBuf[7]=D+C*16+B*256+A*4096;
		return ExceedInputRange;
	}

  }

     return(NoError);
}



/************************************************************/
/*  AnalogInAll_87K											*/
/*															*/	
/*  Command:  "#AA" + [CHK(2)] + CR(1) 						*/ 
/*  Response: ">+00.000+01.001+02.002+03.003-04.004			*/
/*				-05.005-06.006-07.007" + [CHK(2)] + CR(1)	*/
/*															*/
/*  Module: I-87013,I8017H,I-87017,I-87018					*/
/*          ADAM-5013/17/18									*/
/*															*/
/*  [Apr,15,2002] by Kevin									*/
/************************************************************/
WORD CALLBACK AnalogInAll_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{

	char   wPort,wFlag,cTemp[80],wMode;
	WORD   wRet,wAddr,wRetVal,i,j,wCheckSum,wTimeOut,wT,k;
//	WORD   wTotalChannel;
	WORD   wTotalByte;
//	int	   iRet;
	DWORD  dwID;
	char *endptr;
	

	//---------------------- input -------------------------------------
	wPort=(char)dwBuf[0];			// RS-232 port number: 1/2/3/4/..../255
	wAddr=(WORD)dwBuf[1];			// module address: 0x00 to 0xFF
	dwID=dwBuf[2];					// module ID: 0x87013/87017/87018
	wCheckSum=(WORD)dwBuf[3];       // checksum: 0=disable, 1=enable
	wTimeOut=(WORD)dwBuf[4];        // TimeOut constant: normal=100
	wFlag=(char)dwBuf[6];			// flag: 0=no save, 1=save send/receive string
	wMode=(char)dwBuf[7];			// 0: Engineer 1:% FSR 2:Hex

	switch (dwID)
	{
		case 0x87013:
/*			wTotalChannel=4;
			if(wCheckSum)
				wTotalByte=31;
			else 
				wTotalByte=29;*/
			break;    
		case 0x87017:
		case 0x87018:
		case 0x87015:
		case 0x87019:
/*			wTotalChannel=8;
			if(wCheckSum)
				wTotalByte=59;
			else 
				wTotalByte=57;*/
			break; 
		default: return(ModuleIdError);
	}

	sprintf(szCmd8K,"#%02X",wAddr);

	wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);

	if(wFlag)
	{
		strcpy(szSend,szCmd8K);
		strcpy(szReceive,szRec8K);
	}
	if (wRetVal != NoError) return wRetVal;

/*	// Only check the first byte and total bytes.
	if((szRec8K[0]!='>') && (strlen(szRec8K)!=wTotalByte)) 
		return ResultStrCheckError;
	
	for(i=0;i<wTotalChannel;i++)
	{
		//"+03.567" one float value uses 7 bytes.
		for(j=0;j<7;j++)		
			cTemp[j]=szRec8K[1+i*7+j];	
		cTemp[7]=0;
		fBuf[i]=(float)atof(cTemp);
	}
  return(NoError);*/
  switch (dwID)
  {
     
     case 0x87013 :
	 case 0x87017 :
	 case 0x87018 :
	 case 0x87016 :
	 case 0x87015 :
	 case 0x87019 :

		i=1; //szCmd8K[0] is '>'
		k=0;
		j=0;
		if (!wCheckSum) 
	 		wTotalByte=strlen(szRec8K);
		else
			wTotalByte=strlen(szRec8K)-2;
		wRet=NoError;
		switch(wMode)
		{
			case 0: //Engineer
			case 1: //Fsr
			case 3:
			while(i<=wTotalByte) //57 (without '\0')
			{
				if(szRec8K[i]=='+' || szRec8K[i]=='-' || i==wTotalByte)
				{
					if(i!=1 || i==wTotalByte)
					{
						cTemp[j]='\0';
						if( !memcmp(cTemp,"-0000",5) && strlen(cTemp)==5)
						{
							strcpy(cTemp,"-9999");
							wRet=UnderInputRange;
						}
						else if( !memcmp(cTemp,"+9999",5) )
							wRet=ExceedInputRange;
						else if( !memcmp(cTemp,"+999.99",6) )
							wRet=ExceedInputRange;
						fBuf[k]=(float)atof(cTemp);
						if(i==wTotalByte)
							break;
						k++;
						j=0;
					}				  
					cTemp[j++]=szRec8K[i];
				}
				else			
					cTemp[j++]=szRec8K[i];			
				i++;
			}
			break;
			case 2: //Hex
			k=8; //Start from wBuf[8]
			while(i<=wTotalByte) // (without '\0')
			{
				if(szRec8K[i]=='+' || szRec8K[i]=='-')
				{				
					for(j=0;j<5;j++)
						cTemp[j]=szRec8K[i++];
					if(!memcmp(cTemp,"-0000",5))
					{
						strcpy(cTemp,"8000"); //UnderRange or the cable broke
						wRet=UnderInputRange;
					}
					else if(!memcmp(cTemp,"+9999",5))
					{
						strcpy(cTemp,"7FFF"); //OverRange or the cable broke
						wRet=ExceedInputRange;
					}

				}
				else			
				{
					for(j=0;j<4;j++)
						cTemp[j]=szRec8K[i++];					
				}				
				cTemp[j]='\0';
				dwBuf[k++]=(DWORD)strtol(cTemp,&endptr,16); //16 means 0~9,A~F
//				fBuf[k]=(float)atof(cTemp);
				if(!memcmp(cTemp,"7FFF",4))										
					wRet=ExceedInputRange;				
				
					
			}
			break;
		}
		break;
  }
	return wRet;
}
/*WORD CALLBACK AnalogInAllHex_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
	WORD wRetVal;
/*	char   wPort,wFlag,cTemp[80];
	WORD   wAddr,wRetVal,i,j,wCheckSum,wTimeOut,wT;
	WORD   wTotalChannel,wTotalByte;
	DWORD  dwID;*
//---------------------- input -------------------------------------
	//wPort=(char)dwBuf[0];    // RS-232 port number: 1/2/3/4/..../255
	//wAddr=dwBuf[1];          // module address: 0x00 to 0xFF
	//wID=dwBuf[2];            // module ID: 0x87017/87018/87013
	//wCheckSum=dwBuf[3];      // checksum: 0=disable, 1=enable
	//wTimeOut=dwBuf[4];       // TimeOut constant: normal=100
	//wFlag=(char)dwBuf[6];    // flag: 0=no save, 1=save send/receive string
	//---------------------- input -------------------------------------
						// Hex mode
						// dwBuf[8] = Hex input value of channel_0
						// dwBuf[9] = Hex input value of channel_1
						//..........................................
						// dwBuf[15] = Hex input value of channel_7
	dwBuf[7]=2;			// 0: Engineer 1:% FSR 2:Hex

	wRetVal=AnalogInAll_87K(dwBuf,fBuf,szSend,szReceive);

	return wRetVal;
}
WORD CALLBACK AnalogInAllFsr_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
	WORD wRetVal;
/*char wPort,cc[80],c1,c2;
WORD wAddr,wRetVal,i,t,j,wID,wCheckSum,wTimeOut,wT,k;
WORD wRecStrLen;
float  fBuf2[10];*

//---------------------- input -------------------------------------
//wPort=(char)wBuf[0];    // RS-232 port number: 1/2/3/4/..../255
//wAddr=wBuf[1];          // module address: 0x00 to 0xFF
//wID=wBuf[2];            // module ID: 0x87017/87018/87013
//wCheckSum=wBuf[3];      // checksum: 0=disable, 1=enable
//wTimeOut=wBuf[4];       // TimeOut constant: normal=100
//wFlag=(char)wBuf[6];    // flag: 0=no save, 1=save send/receive string
//---------------------- output ------------------------------------
						// Engineer and FSR mode
                        // fBuf[0]=analog input value of channel_0
                        // fBuf[1]=analog input value of channel_1
                        // ........................................
                        // fBuf[7]=analog input value of channel_7
	dwBuf[7]=1;		    // 0: Engineer 1:% FSR 2:Hex

	wRetVal=AnalogInAll_87K(dwBuf,fBuf,szSend,szReceive);

	return wRetVal;
}*/


/************************************************************************/
/* -------------------------------------------------------------------- */
WORD CALLBACK AnalogInFsr_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
  char   wPort,wFlag,cc[80],c1,c2;
  WORD   wAddr,wRetVal,i,j,wChannel,wCheckSum,wT,wTimeOut;
  WORD   wRecStrLen,wSlot;
  DWORD  dwID;

  //---------------------- input -------------------------------------
  wPort=(char)dwBuf[0];     // RS-232 port number: 1/2/3/4/..../255
  wAddr=(WORD)dwBuf[1];     // module address: 0x00 to 0xFF
  dwID=dwBuf[2];            // module ID: 0x87017/0x87018/87013
  wCheckSum=(WORD)dwBuf[3]; // checksum: 0=disable, 1=enable
  wTimeOut=(WORD)dwBuf[4];  // TimeOut constant: normal=100
  wChannel=(WORD)dwBuf[5];  // channel number for multi-channel
  wFlag=(char)dwBuf[6];     // flag: 0=no save, 1=save send/receive string
  wSlot=(WORD)dwBuf[7];     // Slot Number
  //---------------------- output ------------------------------------
                        // fBuf[0]=analog input value

   switch (dwID)
   {
       
       case 0x87013 :  if( wChannel>3 )  return(AdChannelError);
		          break;	
	   
       case 0x87017 :  if( wChannel>7 )  return(AdChannelError);
		          break;
	   
       case 0x87018 :  if( wChannel>7 )  return(AdChannelError);
		          break;
       default: return(ModuleIdError);
   }


   if (wChannel>7) return(AdChannelError);
   szCmd8K[0]='#';
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   szCmd8K[3]=wChannel+'0';
   szCmd8K[4]=0;

  if(wFlag==1)
  {
    strcpy(szSend,szCmd8K);
    szReceive[0]=0;
  }
  wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
  if (wFlag==1)       strcpy(szReceive,szRec8K);

  fBuf[0]=(float)0.0;
  if (wRetVal != NoError) return wRetVal;

  if(szRec8K[0] != '>')   return ResultStrCheckError;

  if(wCheckSum==0) wRecStrLen=8; else wRecStrLen=10;

     i=1; j=0;
     while (szRec8K[i])
     {
        cc[j++]=szRec8K[i++];
     }
     cc[j]=0;

     if( wCheckSum )  // checksum enable
        cc[j-2]=0;

     fBuf[0]=(float)atof(cc);

	 //move to here 04/09/16
	if(strlen(szRec8K)==6)	//Total length is 6 bytes
	{
		if( !memcmp(szRec8K,">-0000",6) && strlen(cc)==6)  return UnderInputRange;
		if( !memcmp(szRec8K,">+9999",6) )  return ExceedInputRange;
	}

     return(NoError);
}

WORD CALLBACK AnalogOut_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
  char    wPort,wFlag,c1,c2;
  WORD    wAddr,wRetVal,i,wCheckSum,wTimeOut,wT,wChannel;
  float   fVal;
  WORD    wRecStrLen;
  char    OutCh[10];
  DWORD   dwID;


  //---------------------- input -------------------------------------
  wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
  wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
  dwID=dwBuf[2];           // module ID: 0x87016/21/22/24
  wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
  wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
  wChannel=(WORD)dwBuf[5];      // Not used if module ID is 7016/7021
                             // Channel No.(0 to 1) if module ID is 7022
                             // Channel No.(0 to 3) if module ID is 7024
  wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
  fVal=fBuf[0];          // analog output value
  //---------------------- output ------------------------------------
                          // void
  if( dwID==0x87016 )
  {
     sprintf(OutCh,"%+07.3f",fBuf[0]);

     szCmd8K[0]='$';
     c2=(char)(wAddr&0x0f);
     wAddr=wAddr/16;
     c1=(char)(wAddr&0x0f);
     szCmd8K[1]=HexToAscii(c1);
     szCmd8K[2]=HexToAscii(c2);
     szCmd8K[3]='7';

     szCmd8K[4]=OutCh[0];
     szCmd8K[5]=OutCh[1];
     szCmd8K[6]=OutCh[2];
     szCmd8K[7]=OutCh[3];
     szCmd8K[8]=OutCh[4];
     szCmd8K[9]=OutCh[5];
     szCmd8K[10]=OutCh[6];
     szCmd8K[11]=0;
  }
  else if(dwID==0x87021)
  {
   szCmd8K[0]='#';
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);

   szCmd8K[5]='.';
   szCmd8K[9]=0;


   i=(WORD)(fVal/10.0);
   szCmd8K[3]=i+0x30; fVal-=i*10;

   i=(int)fVal;
   szCmd8K[4]=i+0x30; fVal-=i;

   fVal *= (float)10.0;
   i=(int)fVal;
   szCmd8K[6]=i+0x30; fVal-=(float)i;

   fVal *= (float)10.0;
   i=(int)fVal;
   szCmd8K[7]=i+0x30; fVal-=(float)i;

   fVal *= (float)10.0;
   i=(int)fVal;
   szCmd8K[8]=i+0x30;
  }
  else if( dwID==0x87022 )
  {
     if( wChannel>2 )
     {
         return(AdChannelError);
     }
     sprintf(OutCh,"%06.3f",fBuf[0]);

     szCmd8K[0]='#';
     c2=(char)(wAddr&0x0f);
     wAddr=wAddr/16;
     c1=(char)(wAddr&0x0f);
     szCmd8K[1] = HexToAscii(c1);
     szCmd8K[2] = HexToAscii(c2);
     szCmd8K[3]=(char)(wChannel+0x30);  // channel No.

     szCmd8K[4]=OutCh[0];
     szCmd8K[5]=OutCh[1];
     szCmd8K[6]=OutCh[2];
     szCmd8K[7]=OutCh[3];
     szCmd8K[8]=OutCh[4];
     szCmd8K[9]=OutCh[5];
     szCmd8K[10]=0;
   }
  else if( dwID==0x87024 )
  {
     if( wChannel>3 )
     {
         return(AdChannelError);
     }
     sprintf(OutCh,"%+07.3f",fBuf[0]);
         // sprintf(OutCh,"%+07.1f",fValue);


     szCmd8K[0]='#';
     c2=(char)(wAddr&0x0f);
     wAddr=wAddr/16;
     c1=(char)(wAddr&0x0f);
     szCmd8K[1] = HexToAscii(c1);
     szCmd8K[2] = HexToAscii(c2);
     szCmd8K[3]=(char)(wChannel+0x30);  // channel No.

     szCmd8K[4]=OutCh[0];
     szCmd8K[5]=OutCh[1];
     szCmd8K[6]=OutCh[2];
     szCmd8K[7]=OutCh[3];
     szCmd8K[8]=OutCh[4];
     szCmd8K[9]=OutCh[5];
     szCmd8K[10]=OutCh[6];
     szCmd8K[11]=0;
  }


  else if( dwID==0x87026 )
  {
     if( wChannel>2 )
     {
         return(AdChannelError);
     }
     sprintf(OutCh,"%06.3f",fBuf[0]);

     szCmd8K[0]='#';
     c2=(char)(wAddr&0x0f);
     wAddr=wAddr/16;
     c1=(char)(wAddr&0x0f);
     szCmd8K[1] = HexToAscii(c1);
     szCmd8K[2] = HexToAscii(c2);
     szCmd8K[3]=(char)(wChannel+0x30);  // channel No.

     szCmd8K[4]=OutCh[0];
     szCmd8K[5]=OutCh[1];
     szCmd8K[6]=OutCh[2];
     szCmd8K[7]=OutCh[3];
     szCmd8K[8]=OutCh[4];
     szCmd8K[9]=OutCh[5];
     szCmd8K[10]=0;
   }



  else
     return(ModuleIdError);


   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

  if( dwID==0x87016 )
  {
     if(szRec8K[0] != '!')
     {
        return ResultStrCheckError;
     }
     if(wCheckSum==0) wRecStrLen=3; else wRecStrLen=5;
  }
  else    // 7021, 7024
  {
     if(szRec8K[0] != '>')
     {
        return ResultStrCheckError;
     }
     if(wCheckSum==0) wRecStrLen=1; else wRecStrLen=3;
  }

  if(strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

  return(NoError);
}

WORD CALLBACK AnalogOutHex_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[]) 
{
  char    wPort,wFlag,c1,c2;
  WORD    wAddr,wRetVal,wCheckSum,wTimeOut,wT,wChannel;
  WORD    wRecStrLen;
  char    sHex[5];
  DWORD   dwID;
   
  //---------------------- input -------------------------------------
  wPort=(char)dwBuf[0];     // RS-232 port number: 1/2/3/4/..../255
  wAddr=(WORD)dwBuf[1];     // module address: 0x00 to 0xFF
  dwID=dwBuf[2];            // module ID: 0x87022/0x87026  (0x87024 has no Hex type)
  wCheckSum=(WORD)dwBuf[3]; // checksum: 0=disable, 1=enable
  wTimeOut=(WORD)dwBuf[4];  // TimeOut constant: normal=100
  wChannel=(WORD)dwBuf[5];  // Channel No.(0 to 1)                              
  wFlag=(char)dwBuf[6];     // flag: 0=no save, 1=save send/receive string
  
  if(dwID==0x87022)//87022 12bit
  	sprintf(sHex,"%03X",dwBuf[7]); //analog output value(Hexadeciaml Data Foramt)
  else if(dwID==0x87026)  //87026 16bit
	sprintf(sHex,"%04X",dwBuf[7]); //analog output value(Hexadeciaml Data Foramt)  	
 		
  //---------------------- output ------------------------------------
  if(dwID==0x87022)
  {
   szCmd8K[0]='#';
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   szCmd8K[3]=(char)(wChannel+0x30);  // channel No.
   szCmd8K[4]=  sHex[0];
   szCmd8K[5]=  sHex[1];	
   szCmd8K[6]=  sHex[2];
   szCmd8K[7]=0;
  }
  else if(dwID==0x87026)
  {
   szCmd8K[0]='#';
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   szCmd8K[3]=(char)(wChannel+0x30);  // channel No.
   szCmd8K[4]=  sHex[0];   
   szCmd8K[5]=  sHex[1];	
   szCmd8K[6]=  sHex[2];   
   szCmd8K[7]=  sHex[3];  
   szCmd8K[8]=  0;
   
  }
  else
     return(ModuleIdError);


   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

	if(szRec8K[0] != '>')
    {
		return ResultStrCheckError;
    }
    if(wCheckSum==0) wRecStrLen=1; else wRecStrLen=3;
  
  if(strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

  return(NoError);
}
/* -------------------------------------------------------------------- */

 WORD CALLBACK AnalogOutFsr_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[]) 
 {
  char    wPort,wFlag,c1,c2;
  WORD    wAddr,wRetVal,i,wCheckSum,wTimeOut,wT,wChannel;
  WORD    wRecStrLen;
  float   fVal;
  DWORD   dwID;

  //---------------------- input -------------------------------------
  wPort=(char)dwBuf[0];     // RS-232 port number: 1/2/3/4/..../255
  wAddr=(WORD)dwBuf[1];     // module address: 0x00 to 0xFF
  dwID=dwBuf[2];            // module ID: 0x87022/0x87026 (0x87024 has no Fsr type)
  wCheckSum=(WORD)dwBuf[3]; // checksum: 0=disable, 1=enable
  wTimeOut=(WORD)dwBuf[4];  // TimeOut constant: normal=100
  wChannel=(WORD)dwBuf[5];  // Channel No.(0 to 1)
  wFlag=(char)dwBuf[6];     // flag: 0=no save, 1=save send/receive string
  
  fVal=fBuf[0];             // analog output value 		
  //---------------------- output ------------------------------------
  if(dwID==0x87022 || dwID==0x87026)
  {
   szCmd8K[0]='#';
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   szCmd8K[3]=(char)(wChannel+0x30);  // channel No.
   szCmd8K[4]=  '+';

   i=(WORD)(fVal/100.0);
   szCmd8K[5]=i+0x30; fVal-=i*100;

   i=(int)(fVal/10.0);
   szCmd8K[6]=i+0x30; fVal-=i*10;
	
   i=(int)fVal;
   szCmd8K[7]=i+0x30; fVal-=i;
   szCmd8K[8]='.';
   fVal *= (float)10.0;
   i=(int)fVal;
   szCmd8K[9]=i+0x30; fVal-=(float)i;

   fVal *= (float)10.0;
   i=(int)fVal;
   szCmd8K[10]=i+0x30; fVal-=(float)i;
	szCmd8K[11]=0;
  }
  else
     return(ModuleIdError);


   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

	if(szRec8K[0] != '>')
    {
		return ResultStrCheckError;
    }
    if(wCheckSum==0) wRecStrLen=1; else wRecStrLen=3;
  
  if(strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

  return(NoError);
 }
/* -------------------------------------------------------------------- */
 WORD CALLBACK AnalogOutReadBackHex_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char  wPort,wFlag,c1,c2;
   WORD  wAddr,wRetVal,wReadType,wCheckSum,wT,wTimeOut,wChannel;
   WORD  wRecStrLen;
   DWORD dwID;

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];        // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];        // module address: 0x00 to 0xFF
   dwID=dwBuf[2];               // module ID: 0x87022/0x87026   (87024 has no Hex mode) 
   wCheckSum=(WORD)dwBuf[3];    // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];     // TimeOut constant: normal=100
   wReadType=(WORD)dwBuf[5];    // for 8022/8026
                                //     0: command read back ($AA6)
                                //     1: analog output of current path read back ($AA8)
   wFlag=(char)dwBuf[6];        // flag: 0=no save, 1=save send/receive string
   wChannel=(WORD)dwBuf[7];     //   Channel No.(0 to 1)
                                //   Not used,            else
   //---------------------- output ------------------------------------
							// dwBuf[9]=analog output value read back(Hex)

   switch(dwID)
   {
       case 0x87022:
       case 0x87026:
             if( wChannel>2 )
                 return(CmdError);
             szCmd8K[0]='$';
             c2=(char)(wAddr&0x0f);
             wAddr=wAddr/16;
             c1=(char)(wAddr&0x0f);
             szCmd8K[1] = HexToAscii(c1);
             szCmd8K[2] = HexToAscii(c2);

             if (wReadType==0) szCmd8K[3]='6';
             else if (wReadType==1) szCmd8K[3]='8';
             else return(CmdError);

             szCmd8K[4]=(char)(wChannel+'0');  // channel No.
             szCmd8K[5]=0;
             break;

       default: return(ModuleIdError);
   }


   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=6; else wRecStrLen=8; //!01FFF
   if(dwID==0x87026 ) wRecStrLen+=1; //!01FFFF

//   if(strlen(szRec8K) != wRecStrLen) return ResultStrCheckError; //01/08/2003 by sean

   sscanf(szRec8K+3,"%X",&dwBuf[9]);

   return(NoError);
}
/* -------------------------------------------------------------------- */
/******************************************************/
/*------  Read Configuration Status for 87024 ---------*/
WORD CALLBACK ReadConfigurationStatus_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,c1,c2;
   WORD   wAddr,wRetVal,wCheckSum,wTimeOut,wT,wFlag;
   WORD   wRecStrLen,wSlot,wChannel;
   DWORD  dwID;

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];    // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];    // module address: 0x00 to 0xFF
   dwID=dwBuf[2];           // module ID: 0x87024
   wCheckSum=(WORD)dwBuf[3];// checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4]; // TimeOut constant: normal=100
   wChannel=(WORD)dwBuf[5]; // channel
   wFlag=(WORD)dwBuf[6];    // flag: 0=no save, 1=save send/receive string
   wSlot=(WORD)dwBuf[7];    // slot
   //---------------------- output ------------------------------------
   // dwBuf[8]   Output Range: 0x30, 0x31, 0x32              
   // dwBuf[9]   Slew rate             

   switch (dwID)
   {
       case 0x87024 :  if( wChannel>3 )  return(AdChannelError);
		          break;	
       default: return(ModuleIdError);
   }

   szCmd8K[0]='$';    // $aa2
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1]=HexToAscii(c1);
   szCmd8K[2]=HexToAscii(c2);
   szCmd8K[3]='2';
   szCmd8K[4]=0;  

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if (wFlag==1)       strcpy(szReceive,szRec8K);

   if (wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=9; else wRecStrLen=11;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   dwBuf[8]=AsciiToHex(szRec8K[3])*16+AsciiToHex(szRec8K[4]);
   dwBuf[9]=(AsciiToHex(szRec8K[7])*16+AsciiToHex(szRec8K[8]))>>2;   
   
   return(NoError);
}







/******************************************************/
/*------  Setting Start-Up Value for 87024 ---------*/
WORD CALLBACK SetStartUpValue_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,c1,c2;
   WORD   wAddr,wRetVal,wCheckSum,wTimeOut,wT,wFlag;
   WORD   wRecStrLen,wChannel;
   DWORD  dwID;

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];    // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];    // module address: 0x00 to 0xFF
   dwID=dwBuf[2];           // module ID: 0x87024
   wCheckSum=(WORD)dwBuf[3];// checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4]; // TimeOut constant: normal=100
   wChannel=(WORD)dwBuf[5]; // channel
   wFlag=(WORD)dwBuf[6];    // flag: 0=no save, 1=save send/receive string
//   wSlot=(WORD)dwBuf[7];    // slot
      
   switch (dwID)
   {
       case 0x87024 :  if( wChannel>3 )  return(AdChannelError);
		          break;	
       default: return(ModuleIdError);
   }

   szCmd8K[0]='$';    // $aa4n
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1]=HexToAscii(c1);
   szCmd8K[2]=HexToAscii(c2);
   szCmd8K[3]='4';
   szCmd8K[4]=wChannel+'0';
   szCmd8K[5]=0;  

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if (wFlag==1)       strcpy(szReceive,szRec8K);

   if (wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=3; else wRecStrLen=5;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   return(NoError);
}




/******************************************************/
/*------  Reading Start-Up Value for 87024 ---------*/
WORD CALLBACK ReadStartUpValue_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,c1,c2,cc[10];
   WORD   wAddr,wRetVal,wCheckSum,wTimeOut,wT,wFlag;
   WORD   wSlot,wChannel,i;
//   WORD   wRecStrLen;
   DWORD  dwID;

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];    // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];    // module address: 0x00 to 0xFF
   dwID=dwBuf[2];           // module ID: 0x87024
   wCheckSum=(WORD)dwBuf[3];// checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4]; // TimeOut constant: normal=100
   wChannel=(WORD)dwBuf[5]; // channel
   wFlag=(WORD)dwBuf[6];    // flag: 0=no save, 1=save send/receive string
   wSlot=(WORD)dwBuf[7];    // slot
   //---------------------- output ------------------------------------
   // fBuf[0]: the Start-Up Value   
      
   switch (dwID)
   {
       case 0x87024 :  if( wChannel>3 )  return(AdChannelError);
		          break;	
       default: return(ModuleIdError);
   }

   szCmd8K[0]='$';    // $aa7n
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1]=HexToAscii(c1);
   szCmd8K[2]=HexToAscii(c2);
   szCmd8K[3]='7';
   szCmd8K[4]=wChannel+'0';
   szCmd8K[5]=0;  

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if (wFlag==1)       strcpy(szReceive,szRec8K);

   if (wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

//   if(wCheckSum==0) wRecStrLen=10; else wRecStrLen=12;

//   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   for(i=3; i<=8; i++)
   {
        cc[i-3]=szRec8K[i];
   }
   cc[6]=0;

   fBuf[0]=(float)atof(cc);

   return(NoError);
}








WORD CALLBACK DigitalOut_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char  wPort,wFlag,c1,c2,A,B,C,D;
   WORD  wAddr,wRetVal,wCheckSum,wTimeOut,wT;//,wAddr2
   WORD  wRecStrLen;
   DWORD dwID,dwData;
   int i;
   //char  szCmd2[80];

   //---------------------- input ---------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   dwID=dwBuf[2];           // module ID: 0x87054/55/56/57/60/63/64/65/66/68/41
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   dwData=dwBuf[5];         // 16-bit digital data to output
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   //---------------------- output -----------------------
   // void

   //@AA(Data)[CHK](cr)
   szCmd8K[0]='@';
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);

   switch (dwID)
   {
		case 0x87041: //32 channels
		           dwData&=0xFFFFFFFF;
				   for(i=0;i<8;i++)
				   {
						A=(char)(dwData >> i*4) & 0x0f;
						szCmd8K[10-i]=HexToAscii(A);
				   }
					szCmd8K[11]=0;
/*	               D=dwData&0x0f; dwData=dwData/16;
	               C=dwData&0x0f; dwData=dwData/16;
	               B=dwData&0x0f; dwData=dwData/16;
	               A=dwData&0x0f;
	               szCmd8K[3]=HexToAscii(A);
		           szCmd8K[4]=HexToAscii(B);
	               szCmd8K[5]=HexToAscii(C);
	               szCmd8K[6]=HexToAscii(D);
	               szCmd8K[7]=0;*/
			break;
       case 0x87054:  //return(54);
       case 0x87055:  //return(55);
       case 0x87064:  //return(64);
       case 0x87065:  ///return(65);
       case 0x87066:  //return(66);
       case 0x87069:
       case 0x87068:  //return(68);

				   dwData&=0x00FF;
				   B=(char)dwData&0x0f; dwData=dwData/16;
                   A=(char)dwData&0x0f;
		           szCmd8K[3]=HexToAscii(A);
		           szCmd8K[4]=HexToAscii(B);
                   szCmd8K[5] = 0;
				   break;

       case 0x87056: 	  //16 channels 
	   case 0x87057:	  //16 channels 
		           dwData&=0xFFFF;
	               D=(char)dwData&0x0f; dwData=dwData/16;
	               C=(char)dwData&0x0f; dwData=dwData/16;
	               B=(char)dwData&0x0f; dwData=dwData/16;
	               A=(char)dwData&0x0f;
	               szCmd8K[3]=HexToAscii(A);
		           szCmd8K[4]=HexToAscii(B);
	               szCmd8K[5]=HexToAscii(C);
	               szCmd8K[6]=HexToAscii(D);
	               szCmd8K[7]=0;
		           break;

       case 0x87060:  //6 channels
				   dwData&=0x003F;
				   B=(char)dwData&0x0f; dwData=dwData/16;
                   A=(char)dwData&0x0f;
		           szCmd8K[3]=HexToAscii(A);
		           szCmd8K[4]=HexToAscii(B);
                   szCmd8K[5] = 0;
		           break;
       case 0x87063: //4 channels          // 01/06/2003 by sean              
				   dwData&=0x000F;
				   B=(char)dwData&0x0f; 
//				   dwData=dwData/16;
//                 A=dwData&0x0f;
                   szCmd8K[3]=HexToAscii(B);
                   szCmd8K[4]=0;
/*		           szCmd8K[3]=HexToAscii(A);
		           szCmd8K[4]=HexToAscii(B);
                   szCmd8K[5] = 0;*/
		           break;        

       default: return(ModuleIdError);
   }



   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '>')   return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=1; else wRecStrLen=3;
  
   if(strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   return(NoError);
}



WORD CALLBACK DigitalBitOut_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char  wPort,wFlag,c1,c2; //,A,B,C,D,i;
   WORD  wAddr,wRetVal,wChannel,wData,wCheckSum,wTimeOut,wT;//,wAddr2
   WORD  wRecStrLen;
   DWORD dwID;
   //char  szCmd2[80];

   //---------------------- input ---------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   dwID=dwBuf[2];           // module ID: 0x87054/55/56/57/60/63/64/65/66/68/41
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   //wData=(WORD)dwBuf[5];         // don't care
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   wChannel=(WORD)dwBuf[7];      // which channel to output
   wData=(WORD)dwBuf[8];         // 16-bit digital data to output
   //---------------------- output -----------------------
                        // void

   if( wData>1 )
     return DataError;

   szCmd8K[0]='#';
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);

   switch (dwID)
   {
		case 0x87041: //#AABBDD BB=Ac(0-7bit),Bc(8-15it),Cc(16-23bit),Dc(24-31bit)
			if( wChannel>31)  return(AdChannelError);
			if( wChannel>23)
				szCmd8K[3]='D';
			else if( wChannel>15)
				szCmd8K[3]='C';
            else if( wChannel>7 )
				szCmd8K[3]='B';
            else
				szCmd8K[3]='A';

			wChannel=wChannel%8;
            szCmd8K[4]=wChannel+'0';
            szCmd8K[5]='0';
            szCmd8K[6]=wData+'0';
            szCmd8K[7]=0;
			break;
       case 0x87054:  //return(54);
       case 0x87055:  //return(55);
       case 0x87064:  //return(64);
       case 0x87065:  ///return(65);
       case 0x87066:  //return(66);
       case 0x87069:
       case 0x87068:  //return(68);

                   if( wChannel>7 )  return(AdChannelError);
				   szCmd8K[3] = 'A';
                   szCmd8K[4]=wChannel+'0';
                   szCmd8K[5]='0';
                   szCmd8K[6]=wData+'0';
				   szCmd8K[7]=0;
				   break;

       case 0x87056: 
	   case 0x87057:	   
                   if( wChannel>15 )  return(AdChannelError);
                   if( wChannel>7 )
				   {
					   szCmd8K[3]='B';
					   wChannel-=8;
				   }
                   else    
				   {
                       szCmd8K[3]='A';
				   }
                   szCmd8K[4]=wChannel+'0';
                   szCmd8K[5]='0';
                   szCmd8K[6]=wData+'0';
                   szCmd8K[7]=0;

		           break;

       case 0x87060:  
                   if( wChannel>5 )  return(AdChannelError);
				   szCmd8K[3] = 'A';
                   szCmd8K[4]=wChannel+'0';
                   szCmd8K[5]='0';
                   szCmd8K[6]=wData+'0';
				   szCmd8K[7]=0;
		           break;
       case 0x87063:  
                   if( wChannel>3 )  return(AdChannelError);
				   szCmd8K[3] = 'A';
                   szCmd8K[4]=wChannel+'0';
                   szCmd8K[5]='0';
                   szCmd8K[6]=wData+'0';
				   szCmd8K[7]=0;
		           break;        

       default: return(ModuleIdError);
   }



   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '>')   return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=1; else wRecStrLen=3;
  
   if(strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   return(NoError);
}





WORD CALLBACK DigitalIn_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{

 char wPort,wFlag,c1,c2,A,B,C,D;
 WORD wRet,wAddr,wCheckSum,wTimeOut,wRecStrLen,wT;
 DWORD  dwID,mask,dwT;


 //---------------------- input ---------------------------
 wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
 wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
 dwID=dwBuf[2];           // module ID: 0x87054/55/56/57/60/63/64/65/66/68/40
 wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
 wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
 wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
 //---------------------- output -----------------------
                        // void

 szCmd8K[0]='$'; //$AA6
 c2=(char)(wAddr&0x0f);
 wAddr=wAddr/16;
 c1=(char)(wAddr&0x0f);
 szCmd8K[1] = HexToAscii(c1);
 szCmd8K[2] = HexToAscii(c2);
 szCmd8K[3]='6';
 szCmd8K[4]=0;

 if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
 wRet=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
 if(wFlag==1)      strcpy(szReceive,szRec8K);
 dwBuf[5]=0;
 if(wRet != NoError) return wRet;
 if(szRec8K[0] != '!') return ResultStrCheckError;
 if(dwID==0x87040)
 {
	if(wCheckSum==0) wRecStrLen=9; else wRecStrLen=11;
 }
 else
 {
	if(wCheckSum==0) wRecStrLen=7; else wRecStrLen=9;
 }
 if(strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;
 A=AsciiToHex(szRec8K[1]);
 B=AsciiToHex(szRec8K[2]);
 C=AsciiToHex(szRec8K[3]);
 D=AsciiToHex(szRec8K[4]);
 switch(dwID)
   {
	case 0x87040:
				sscanf(szRec8K+1,"%08x",&dwT); //!00000000
				mask=0xffffffff;
				break;
	case 0x87051:
	case 0x87053: //16 channels
		         dwT=D+C*16+B*256+A*4096;	
				 mask=0xffff;
		         break;
    case 0x87052:
    case 0x87058:
		         dwT=B+A*16;
				 mask=0xff;
				 break;
    case 0x87054:
	case 0x87055:
		         dwT=D+C*16;
				 mask=0xff;
				 break;

	case 0x87063:
                 dwT=D+C*16;
				 mask=0xf;
				 break;
		  
    default:return(ModuleIdError);
   }

 dwBuf[5]=dwT&mask;
 return(wRet);

}

WORD CALLBACK DigitalOutReadBack_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{

 char wPort,wFlag,c1,c2,A,B,C,D;
 WORD wRet,wAddr,wCheckSum,wTimeOut,wT,wRecStrLen;
 DWORD  dwID,dwT,mask;


 //---------------------- input ---------------------------
 wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
 wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
 dwID=dwBuf[2];           // module ID: 0x87054/55/56/57/60/63/64/65/66/68/41
 wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
 wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
 wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
 //---------------------- output -----------------------
                        // void

 szCmd8K[0]='$';
 c2=(char)(wAddr&0x0f);
 wAddr=wAddr/16;
 c1=(char)(wAddr&0x0f);
 szCmd8K[1] = HexToAscii(c1);
 szCmd8K[2] = HexToAscii(c2);
 szCmd8K[3]='6';
 szCmd8K[4]=0;

 if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
 wRet=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
 if(wFlag==1)      strcpy(szReceive,szRec8K);
 dwBuf[5]=0;
 if(wRet != NoError) return wRet;
 if(szRec8K[0] != '!') return ResultStrCheckError;
 if(dwID==0x87041) 
	if(wCheckSum==0) wRecStrLen=9; else wRecStrLen=11; 
 else 
	if(wCheckSum==0) wRecStrLen=7; else wRecStrLen=9; 
 if(strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;
 A=AsciiToHex(szRec8K[1]);
 B=AsciiToHex(szRec8K[2]);
 C=AsciiToHex(szRec8K[3]);
 D=AsciiToHex(szRec8K[4]);
 switch(dwID)
   {
	case 0x87041:
				sscanf(szRec8K+1,"%08x",&dwT); //!00000000
				mask=0xffffffff;
				break;
	case 0x87056:
	case 0x87057:
		         dwT=D+C*16+B*256+A*4096;	
				 mask=0xffff;
		         break;
    /*case 0x87052:
		         wT=B+A*16;
				 mask=0xff;
				 break;*/
    case 0x87054:
	case 0x87055:
    case 0x87064:
	case 0x87065:
    case 0x87066:
    case 0x87069:
	case 0x87068:
		         dwT=B+A*16;
				 mask=0xff;
				 break;

    case 0x87060:
		         dwT=B+A*16;
				 mask=0x3f;
				 break;

	case 0x87063:
                 dwT=B+A*16;
				 mask=0xf;
				 break;
		  
    default:return(ModuleIdError);
   }

 dwBuf[5]=dwT&mask;
 return(wRet);

}
/* -------------------------------------------------------------------- */

WORD CALLBACK AnalogOutReadBack_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char  wPort,wFlag,cc[80],c1,c2;
   WORD  wAddr,wRetVal,i,j,wReadType,wCheckSum,wT,wTimeOut,wChannel;
//   WORD  wRecStrLen;
   DWORD dwID;

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];  // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];        // module address: 0x00 to 0xFF
   dwID=dwBuf[2];          // module ID: 0x87016/87021/87024/87022/87026
   wCheckSum=(WORD)dwBuf[3];    // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];     // TimeOut constant: normal=100
   wReadType=(WORD)dwBuf[5];    // for 7016 :  Don't Care
                          // for 7021/7022/7024
                          //     0: command read back ($AA6)
                          //     1: analog output of current path read back ($AA8)
   wFlag=(char)dwBuf[6];  // flag: 0=no save, 1=save send/receive string
   wChannel=(WORD)dwBuf[7];     //   Channel No.(0 to 3), if wID is 7024
                          //   Not used,            else
   //---------------------- output ------------------------------------
                          // fBuf[0]=analog output value read back

   switch(dwID)
   {
       case 0x87016:
             szCmd8K[0]='$';
             c2=(char)(wAddr&0x0f);
             wAddr=wAddr/16;
             c1=(char)(wAddr&0x0f);
             szCmd8K[1] = HexToAscii(c1);
             szCmd8K[2] = HexToAscii(c2);
             szCmd8K[3]='6';
             szCmd8K[4]=0;
             break;
       case 0x87021:
             if (wReadType==0) szCmd8K[3]='6';
             else if (wReadType==1) szCmd8K[3]='8';
             else return(CmdError);

             szCmd8K[0]='$';
             c2=(char)(wAddr&0x0f);
             wAddr=wAddr/16;
             c1=(char)(wAddr&0x0f);
             szCmd8K[1] = HexToAscii(c1);
             szCmd8K[2] = HexToAscii(c2);
             szCmd8K[4]=0;
             break;
       case 0x87022:
	   case 0x87026:
             if( wChannel>2 )
                 return(CmdError);
             szCmd8K[0]='$';
             c2=(char)(wAddr&0x0f);
             wAddr=wAddr/16;
             c1=(char)(wAddr&0x0f);
             szCmd8K[1] = HexToAscii(c1);
             szCmd8K[2] = HexToAscii(c2);

             if (wReadType==0) szCmd8K[3]='6';
             else if (wReadType==1) szCmd8K[3]='8';
             else return(CmdError);

             szCmd8K[4]=(char)(wChannel+'0');  // channel No.
             szCmd8K[5]=0;
             break;
       case 0x87024:
             if( wChannel>3 )
                 return(CmdError);
             szCmd8K[0]='$';
             c2=(char)(wAddr&0x0f);
             wAddr=wAddr/16;
             c1=(char)(wAddr&0x0f);
             szCmd8K[1] = HexToAscii(c1);
             szCmd8K[2] = HexToAscii(c2);

             if (wReadType==0) szCmd8K[3]='6';
             else if (wReadType==1) szCmd8K[3]='8';
             else return(CmdError);

             szCmd8K[4]=(char)(wChannel+'0');  // channel N0.
             szCmd8K[5]=0;
             break;
       default: return(ModuleIdError);
   }


   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   fBuf[0]=(float)0.0;
   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

//   if(wCheckSum==0) wRecStrLen=9; else wRecStrLen=11;
//   if( dwID==0x87016 || dwID==0x87024 ) wRecStrLen+=1;
//   if(strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   i=3; j=0;
   while (szRec8K[i])
   {
      cc[j++]=szRec8K[i++];
   }
   cc[j]=0;

   if( wCheckSum )  // checksum enable
      cc[j-2]=0;
   fBuf[0]=(float)atof(cc);

   return(NoError);
}

/* -------------------------------------------------------------------- */
 WORD CALLBACK AnalogOutReadBackFsr_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   WORD  wRecStrLen,wCheckSum;
   WORD wRet;
   char wFlag;
   DWORD dwID;

   //---------------------- input -------------------------------------
   //dwBuf[0];               // RS-232 port number: 1/2/3/4/..../255
   //dwBuf[1];               // module address: 0x00 to 0xFF
   dwID=dwBuf[2];            // module ID: 87022/87026
   wCheckSum=(WORD)dwBuf[3]; // checksum: 0=disable, 1=enable
   //dwBuf[4];               // TimeOut constant: normal=100
   //dwBuf[5];               // for 7021/7022/7024
                             //     0: command read back ($AA6)
                             //     1: analog output of current path read back ($AA8)
   wFlag=(char)dwBuf[6];     // flag: 0=no save, 1=save send/receive string
   //dwBuf[7];               //   Channel No.(0 to 3)
   //---------------------- output ------------------------------------
                          // fBuf[0]=analog output value read back

   switch(dwID)
   {                 
       case 0x87022:
	   case 0x87026: 
             break;
       default: return(ModuleIdError);
   }

	if(!wFlag)
		wFlag=1;
	wRet=AnalogOutReadBack_87K(dwBuf,fBuf,szSend,szReceive);
	if(!wRet)
	{
		if(wCheckSum==0) wRecStrLen=10; else wRecStrLen=12;
	    if(strlen(szReceive) != wRecStrLen) return ResultStrCheckError;
		if(!dwBuf[6]) //if flag=0; set szReceive=null
			strnset(szReceive,0x00,strlen(szReceive));
		return(NoError);
	}
	else
		return wRet;
 }
/* -------------------------------------------------------------------- */

WORD CALLBACK DigitalInCounterRead_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char wPort,wFlag,c1,c2;
   WORD wAddr,wRetVal,wCheckSum,wTimeOut,wChannel,wT,wTemp; //,wCounter;
   //WORD A,B,C,D,E,F,G,H;
   WORD wRecStrLen;
   char cc[10];
   DWORD dwID;

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   dwID=dwBuf[2];           // module ID: 0x87051/52/53/54/55/63/40
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wChannel=(WORD)dwBuf[5];      // Channel No. 0~16 ,0~31(87040)
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   //---------------------- output ------------------------------------
   // w7000[7]= DigitalIn Counter Value

   switch (dwID)
   {
       case 0x87063 : if( wChannel>4 )
                        return InvalidateChannelNo;
                     break;
       case 0x87052 : 
       case 0x87054 :
	   case 0x87055 :
	   case 0x87058:
                     if( wChannel>8 )
                        return InvalidateChannelNo;
                     break;
       case 0x87051 : 
	   case 0x87053 :
                     if( wChannel>16 )
                        return InvalidateChannelNo;
                     break;
	   case 0x87040 :
                     if( wChannel>32 )
                        return InvalidateChannelNo;
                     break;
       default: return(ModuleIdError);
   }

   //***   #AAN  read DigitalIn Channel N's Counter Value
   szCmd8K[0]='#';
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   if(dwID==0x87040) //32bit  #AANN
   {
	   wTemp=wChannel>>4 & 0xF;
	szCmd8K[3] = HexToAscii(wTemp);
		wTemp=wChannel& 0xF;
	szCmd8K[4] = HexToAscii(wTemp);
	szCmd8K[5]=0;
   }
   else //<32 bit #AAN
   {
	szCmd8K[3] = HexToAscii(wChannel);
	szCmd8K[4] = 0;
   }

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=8; else wRecStrLen=10;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   cc[0]=szRec8K[3];  cc[1]=szRec8K[4];  cc[2]=szRec8K[5]; //!AABBBBB(BBBBB=>00000~65535)
   cc[3]=szRec8K[6];  cc[4]=szRec8K[7];  cc[5]=0;
   dwBuf[7]=(WORD)(atoi(cc));

   return(NoError);
}



WORD CALLBACK ClearDigitalInCounter_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char wPort,wFlag,c1,c2;
   WORD wAddr,wRetVal,wCheckSum,wTimeOut,wT,wChannel,wTemp; //,wCounter
   //WORD A,B,C,D,E,F,G,H;
   WORD wRecStrLen;
   DWORD dwID;

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   dwID=dwBuf[2];           // module ID: 0x87051/52/53/54/55/63/40
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wChannel=(WORD)dwBuf[5];      // Channel No.
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string

   switch (dwID)
   {
       case 0x87063 : if( wChannel>4 )
                        return InvalidateChannelNo;
                     break;
       case 0x87052 : 
       case 0x87054 :
	   case 0x87055 :
	   case 0x87058:
                     if( wChannel>8 )
                        return InvalidateChannelNo;
                     break;
       case 0x87051 : 
	   case 0x87053 :
                     if( wChannel>16 )
                        return InvalidateChannelNo;
                     break;
	   case 0x87040 :
                     if( wChannel>32 )
                        return InvalidateChannelNo;
                     break;
       default: return(ModuleIdError);
   }


   //***   $AACN   Clear DigitalIn Channel N's Counter Value
   szCmd8K[0]='$';
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   szCmd8K[3]='C';
   if(dwID==0x87040) //32bit  #AACNN
   {
	   wTemp=wChannel>>4 & 0xF;
	szCmd8K[4] = HexToAscii(wTemp);
		wTemp=wChannel& 0xF;
	szCmd8K[5] = HexToAscii(wTemp);
	szCmd8K[6] = 0;
   }
   else //<32 bit #AACN
   {
	szCmd8K[4] = HexToAscii(wChannel); //wChannel+'0';
	szCmd8K[5] = 0;
   }

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=3; else wRecStrLen=5;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   return(NoError);
}


WORD CALLBACK DigitalInLatch_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char wPort,wFlag,c1,c2;
   WORD wAddr,wRetVal,wCheckSum,wTimeOut,wLatchStatus,wT; //,wCounter
   WORD A,B,C,D; //,E,F,G,H;
   WORD wRecStrLen;
   DWORD dwID,dwT,mask;

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   dwID=dwBuf[2];           // module ID: 0x87051/52/53/54/55/63/40
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wLatchStatus=(WORD)dwBuf[5];  // 0: select to latch low
                           // 1: select to latch high
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   //---------------------- output ------------------------------------
   //  w7000[7]: the latched data

   //***   $AALS  S:0 latch low  S:1 latch high
   szCmd8K[0]='$';
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   szCmd8K[3]='L';
   if( wLatchStatus==0 )
      szCmd8K[4]='0';
   else
      szCmd8K[4]='1';
   szCmd8K[5]=0;

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

 if(dwID==0x87040)
 {
	if(wCheckSum==0) wRecStrLen=9; else wRecStrLen=11;
	if(strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;
 }
 else
 {
	if(wCheckSum==0) wRecStrLen=7; else wRecStrLen=9;
	if(strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;
 }


   A=AsciiToHex(szRec8K[1]);
   B=AsciiToHex(szRec8K[2]);
   C=AsciiToHex(szRec8K[3]);
   D=AsciiToHex(szRec8K[4]);

switch(dwID)
   {
	case 0x87040: //32bit
				sscanf(szRec8K+1,"%08x",&dwT); //!00000000
				mask=0xffffffff;	
				break;
	case 0x87051:
	case 0x87053:
		         dwT=D+C*16+B*256+A*4096;	
				 mask=0xffff;
		         break;
    case 0x87052:
	case 0x87058:
		         dwT=B+A*16;
				 mask=0xff;
				 break;
    case 0x87054:
	case 0x87055:
		         dwT=D+C*16;
				 mask=0xff;
				 break;

	case 0x87063:
                 dwT=D+C*16;
				 mask=0xf;
				 break;
		  
    default:return(ModuleIdError);
   }



   dwBuf[7]=dwT&mask;

   return(NoError);

}



WORD CALLBACK ClearDigitalInLatch_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char wPort,wFlag,c1,c2;
   WORD wAddr,wRetVal,wCheckSum,wTimeOut,wT; //,wLatchStatus,wCounter;
   //WORD A,B,C,D,E,F,G,H;
   WORD wRecStrLen; //,mask;
   DWORD dwID;
   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   dwID=dwBuf[2];           // module ID: 0x7050/52/53/60/63/65/41/44
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   // wLatchStatus=w7000[5];  // 0: select to latch low
                              // 1: select to latch high
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   
   //---   $AAC  ---
   szCmd8K[0]='$';
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   szCmd8K[3]='C';
   szCmd8K[4]= 0 ;
   
   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=3; else wRecStrLen=5;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   return(NoError);
}

//------------------------- ReadCounter -----------------------

WORD CALLBACK ReadCounter(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char wPort,wFlag,wReadMode;
   char szCmd8K_sub[80],szRec8K_sub[80];
   WORD wAddr,wRetVal,wCheckSum,wTimeOut,wT,wRetVal_sub;
   DWORD wID;   
   char valueStr[15];
   unsigned long val;
   unsigned int overf;
   WORD  wSlot,wChannel;  
   wID=dwBuf[2];
   
   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7080
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wChannel=(WORD)dwBuf[5];      // channel number
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   wSlot=(WORD)dwBuf[7];	//wSlot: Slot number 0 ~ 7
   wReadMode =(char)dwBuf[8];	//wReadMode = 0 read counter wReadMode = 1 read and reset wReadMode =2 read counter and overflow 
   //---------------------- output ------------------------------------
                           // dwBuf[9]= Counter or Frequency Value
                           
   switch( wID)	//check module id	
   {
		case 0x7080 :
		case 0x87082:
		case 0x8080: 
		case 0x8082://note this 8082 is 87082 on 8K MCU not i-8082
		break;
		default:
      	return(ModuleIdError);
   }
   
   if(wID==0x7080 || wID==0x87082 || wID==0x8082)
   {	
   		if( wChannel>1 )//check channel count
   		{
       		return(InvalidateCounterNo);
       	}
   		
   		//***   #AAN  read Counter Value
		if(wID==0x7080 || wID==0x87082)
			sprintf(szCmd8K,"#%02X%X",wAddr,wChannel);
		else
			sprintf(szCmd8K,"#%02XS%01XC%01X",wAddr,wSlot,wChannel);
   		wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT); 
        if(wFlag==1) //package command str and receive str
   		{      	
      		//sprintf(szSend,"%s",szCmd8K);
      		//sprintf(szReceive,"%s",szRec8K);      	
   		} 
		if(wRetVal != NoError)
   		{
   			return wRetVal;
   		}

   		
   	    if(wReadMode==1)// clear counter
   	    {
   			//*** $AA6N clear Counter
			if(wID==0x7080 || wID==0x87082)
				sprintf(szCmd8K,"$%02X%X6",wAddr,wChannel);
			else
				sprintf(szCmd8K,"$%02XS%01XC%01X6",wAddr,wSlot,wChannel);
			
   			wRetVal_sub=Send_Receive_Cmd(wPort, szCmd8K_sub, szRec8K_sub, wTimeOut, wCheckSum,&wT);  			
   	    }
   	    else if(wReadMode==2)//read counter and overflow
   	    {
   			//*** $AA7N read overflow flag  
			if(wID==0x7080 || wID==0x87082)
				sprintf(szCmd8K_sub,"$%02X7%X",wAddr,wChannel);
			else
				sprintf(szCmd8K_sub,"$%02XS%01XC%01X7",wAddr,wSlot,wChannel);

			
   			wRetVal_sub=Send_Receive_Cmd(wPort, szCmd8K_sub, szRec8K_sub, wTimeOut, wCheckSum,&wT);  			
   	    }
   	       		
   		if(wReadMode!=0)
   		{
   			if(wRetVal_sub !=NoError)
   			{
      		sprintf(szSend,"%s",szCmd8K_sub);
      		sprintf(szReceive,"%s",szRec8K_sub);      	
   			
				//return wRetVal_sub;	
   			}
   		}
   		
   		if(szRec8K[0] != '>') 
   		{
   				return ResultStrCheckError;
   		}  
   		if(wReadMode!=0)
   		{
   			if(szRec8K_sub[0] != '!') 
   			{
   					return ResultStrCheckError;
   			} 
   		}
   		
   		if(wCheckSum==0) 
   		{        		
   			if( strlen(szRec8K) != 9 && strlen(szRec8K) != 12)
				//szRec8K 9:hex 12:deci ;szRec8K_sub 3=>clear counter, 4=> 7080,87082,8082 read overflow
   			{
   				return ResultStrCheckError;
   			}
		}
		else //wCheckSum==1
		{
   			if(strlen(szRec8K) != 11 && strlen(szRec8K) != 14)//11:hex and checksum 13:deci and checksum
   			{
   				return ResultStrCheckError;
   			}
		}
   		if (strlen(szRec8K)==9 || strlen(szRec8K)==11) //hex format
   		{
				sprintf(valueStr,"0x%s",szRec8K+1);
				sscanf(valueStr,"%08lX",&val);				
				dwBuf[9]=val;
   		}
   		else if (strlen(szRec8K)==12 || strlen(szRec8K)==14) //decimal format
   		{
				sscanf(szRec8K+1,"%lu",&val);
				dwBuf[9]=val;
		}		
   		
   		if(wReadMode==1)//read counter and reset to 0
   		{   				
   			dwBuf[10]=1;//clear ok
   		}
   		else if(wReadMode==2)//read overflow flag
   		{	
   				dwBuf[10]=szRec8K_sub[3] &0xf;
   		}	
	}// end if (wID==0x7080 || wID==0x87082)
   	else if (wID==0x8080)
   	{
   		if( wChannel>7 )
   		{
       		return(InvalidateCounterNo);
       	} 
       	switch(wReadMode)
       	{
       		case 0://read counter
                // #AASiCj
				sprintf(szCmd8K,"#%02XS%XC%X",wAddr,wSlot,wChannel);
   				wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
  				
       		break;
       		case 1:
				//#AASiCjR
				sprintf(szCmd8K,"#%02XS%XC%XR",wAddr,wSlot,wChannel);
   				wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);       		
       		break;
       		case 2: 
				//#AASiCjV
				sprintf(szCmd8K,"#%02XS%XC%XV",wAddr,wSlot,wChannel);
   				wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);       		
	
       		break;
       	}
       	
       	if(wFlag==1)
   		{
      		sprintf(szSend,"%s",szCmd8K);
      		sprintf(szReceive,"%s",szRec8K);
   		}
   		if(wRetVal != NoError)
   		{
   			return wRetVal;
   		}
   		if(szRec8K[0] != '>') 
   		{
   				return ResultStrCheckError;
   		} 

   		switch(wReadMode)
   		{
   			case 0: case 1:   	// case 0 #AASiCj read counter, case 1 #AASiCjR read counter and clear the value	
   				if(wCheckSum==0) 
   				{        		
   					if( strlen(szRec8K) != 9 && strlen(szRec8K) != 12)//9:hex 12:deci format >+0000000000 or >-0000000000
   					{
   						return ResultStrCheckError;
   					}
				}
				else
				{
   					if( strlen(szRec8K) != 11 && strlen(szRec8K) != 14)//11:hex and checksum 13:deci and checksum
   					{
   						return ResultStrCheckError;
   					}
				}
   				
   				if (strlen(szRec8K)==9 || strlen(szRec8K)==11)  // hex value
   				{
					sprintf(valueStr,"0x%s",szRec8K+1);  // must transform the FFFFDDDD to 0xFFFFDDDD 
					sscanf(valueStr,"%08lX",&val);		 // then convert to unsigned long data		
					dwBuf[9]=val;
   				}
   				else if (strlen(szRec8K)==12 || strlen(szRec8K)==14) // decimal value
   				{
					sscanf(szRec8K+1,"%lu",&val);  // here we can convert "1234567890" to unsigned long data
					dwBuf[9]=val;
   				} 
   			break;
   			case 2: //read counter and overflow #AASiCjV
   				if(wCheckSum==0) 
   				{        		
   					if( strlen(szRec8K) != 13 && strlen(szRec8K) != 18)//13:1+8+4 hex   18:1+11+6
   					{
   						return ResultStrCheckError;
   					}
				}
				else
				{
   					if( strlen(szRec8K) != 15 && strlen(szRec8K) != 20)//15:1+8+4+2   18:1+10+5+2
   					{
   						return ResultStrCheckError;
   					}
				}
   				if (strlen(szRec8K)==13 || strlen(szRec8K)==15)// hex >wwwwvvvvvvvv
   				{
   					strncpy(valueStr,szRec8K+1,4);				
					valueStr[4]='\0';
					sscanf(valueStr,"%X",&overf);
					dwBuf[10]=overf & 0xffff; // overflow

   					
					strncpy(valueStr,szRec8K+5,8);
					valueStr[8]='\0';
					sscanf(valueStr,"%lX",&val);
					dwBuf[9]=val; //counter value							 
   				}
   				else if (strlen(szRec8K)==18 || strlen(szRec8K)==20) //deci >+wwwww+vvvvvvvvvv
   				{   											
   					strncpy(valueStr,szRec8K+1,6); //> wwww	
					valueStr[6]='\0';
					sscanf(valueStr,"%du",&overf);
					dwBuf[10]=overf & 0xffff; // overflow
   						
					strncpy(valueStr,szRec8K+7,11);
					valueStr[11]='\0';
					sscanf(valueStr,"%lu",&val);
					dwBuf[9]=val; //counter value				
   				}					   			
   			break;
   		}//end of switch(wReadMode)		  			
	}//end of if (wID==0x8080)
	return(NoError);
}


WORD CALLBACK ReadUpDownDirPulse(long LBuf[],int IBuf[],
        char szSend[], char szReceive[])
{
   char wPort,wFlag,wReadMode;
   //char szCmd8K_sub[80],szRec8K_sub[80],wRetVal_sub;
   WORD wAddr,wRetVal,wCheckSum,wTimeOut,wT;
   long wID;   
   char valueStr[15];
   WORD  wSlot,wChannel;  
   int overf;
   long val;
   wID=LBuf[2];
   
   //---------------------- input -------------------------------------
   wPort=(char)LBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)LBuf[1];         // module address: 0x00 to 0xFF
   wID=LBuf[2];           // module ID: 0x7080
   wCheckSum=(WORD)LBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)LBuf[4];      // TimeOut constant: normal=100
   wChannel=(WORD)LBuf[5];      // channel number
   wFlag=(char)LBuf[6];   // flag: 0=no save, 1=save send/receive string
   wSlot=(WORD)LBuf[7];	//wSlot: Slot number 0 ~ 7
   wReadMode =(char)LBuf[8];	//wReadMode = 0 read counter wReadMode = 1 read and reset wReadMode =2 read counter and overflow 
   //---------------------- output ------------------------------------
                           // dwBuf[9]= Counter or Frequency Value
                           
   switch( wID)	//check module id	
   {		
		case 0x8080:
		break;
		default:
      	return(ModuleIdError);
   }

   if( wChannel>7 )
   {
   	return(InvalidateCounterNo);
   } 
   switch(wReadMode)
   {
       	case 0://read counter
            // #AASiCj
			sprintf(szCmd8K,"#%02XS%XC%X",wAddr,wSlot,wChannel);
   			wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
  			
       	break;
       	case 1:
			//#AASiCjR
			sprintf(szCmd8K,"#%02XS%XC%XR",wAddr,wSlot,wChannel);
   			wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);       		
       	break;
       	case 2: 
			//#AASiCjV
			sprintf(szCmd8K,"#%02XS%XC%XV",wAddr,wSlot,wChannel);
   			wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);       			
       	break;
   }
       	
       	if(wFlag==1)
   		{
      		sprintf(szSend,"%s",szCmd8K);
      		sprintf(szReceive,"%s",szRec8K);
   		}
   		if(wRetVal != NoError)
   		{
   			return wRetVal;
   		}
   		if(szRec8K[0] != '>') 
   		{
   				return ResultStrCheckError;
   		} 

   		switch(wReadMode)
   		{
   			case 0: case 1:   	// case 0 #AASiCj read counter, case 1 #AASiCjR read counter and clear the value	
   				if(wCheckSum==0) 
   				{        		
   					if( strlen(szRec8K) != 9 && strlen(szRec8K) != 12)//9:hex 12:deci format >+0000000000 or >-0000000000
   					{
   						return ResultStrCheckError;
   					}
				}
				else
				{
   					if( strlen(szRec8K) != 11 && strlen(szRec8K) != 14)//11:hex and checksum 13:deci and checksum
   					{
   						return ResultStrCheckError;
   					}
				}
   				if (strlen(szRec8K)==9 || strlen(szRec8K)==11)
   				{   					
					sprintf(valueStr,"0x%s",szRec8K+1);  // must transform the FFFFDDDD to 0xFFFFDDDD 
					sscanf(valueStr,"%08X",&val);
					LBuf[9]=val;
   				}
   				else if (strlen(szRec8K)==12 || strlen(szRec8K)==14)
   				{
					sscanf(szRec8K+1,"%ld",&val);
					LBuf[9]=val;			
   				} 
   			break;
   			case 2: //read counter and overflow #AASiCjV
   				if(wCheckSum==0) 
   				{        		
   					if( strlen(szRec8K) != 13 && strlen(szRec8K) != 18)//13:1+8+4 hex   18:1+11+6
   					{
   						return ResultStrCheckError;
   					}
				}
				else
				{
   					if( strlen(szRec8K) != 15 && strlen(szRec8K) != 20)//15:1+8+4+2   18:1+10+5+2
   					{
   						return ResultStrCheckError;
   					}
				}
   				if (strlen(szRec8K)==13 || strlen(szRec8K)==15)// hex >wwwwvvvvvvvv
   				{
   					
   					valueStr[0]='0';
					valueStr[1]='x';
					strncpy(valueStr+2,szRec8K+1,4);
					valueStr[6]='\0';
					sscanf(valueStr,"%04X",&overf);
					IBuf[0]=overf; // overflow
   						
   					valueStr[0]='0';
					valueStr[1]='x';
					strncpy(valueStr+2,szRec8K+5,8);
					valueStr[10]='\0';
					sscanf(valueStr,"%08X",&val);
					LBuf[9]=val; //counter value				 						 
   				}
   				else if (strlen(szRec8K)==18 || strlen(szRec8K)==20) //deci >+wwwww+vvvvvvvvvv
   				{   											
   					strncpy(valueStr,szRec8K+1,6); //> wwww	
					valueStr[6]='\0';
					sscanf(valueStr,"%d",&overf);
					IBuf[0]=overf; // overflow
   						
					strncpy(valueStr,szRec8K+7,11);
					valueStr[11]='\0';
					sscanf(valueStr,"%ld",&val);
					LBuf[9]=val; //counter value				
   				}					   			
   			break;
   		}//end of switch(wReadMode)	
		return(NoError);
}
 WORD CALLBACK ReadUpDownDirPulse_All(long LBuf[], int IBuf[],
        char szSend[], char szReceive[])
{
   char wPort,wFlag,wReadMode;
   char szCmd8K_sub[80],szRec8K_sub[80];
   WORD wAddr,wRetVal,wCheckSum,wTimeOut,wT,wRetVal_sub;   
   DWORD wID;
   WORD  wSlot,wChannel;  
   DWORD i;	
   char valueStr[256];
   unsigned long val;
   wID=LBuf[2];
   
   //---------------------- input -------------------------------------
   wPort=(char)LBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)LBuf[1];         // module address: 0x00 to 0xFF
   wID=LBuf[2];           // module ID: 0x7080
   wCheckSum=(WORD)LBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)LBuf[4];      // TimeOut constant: normal=100
   wChannel=(WORD)LBuf[5];      // channel number
   wFlag=(char)LBuf[6];   // flag: 0=no save, 1=save send/receive string
   wSlot=(WORD)LBuf[7];
   wReadMode =(char)LBuf[8];	//wReadMode=0 read counter wReadMode= 1  read counter and overflow

   //---------------------- output ------------------------------------
                           // dwBuf[9]~dwBuf[16]= Counter 
                           // dwBuf[17]~dwBuf[24] =overflow                           
 	switch( wID)		
   {
		case 0x8080:
		break;
		default:
      	return(ModuleIdError);
   }

   	if( wChannel>7 )
   	{
    	return(InvalidateCounterNo);
    }   	
   	//***   #AASi read Counter 
	sprintf(szCmd8K,"#%02XS%X",wAddr,wSlot);
   	wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
	   
	if(wReadMode==1)
   	{
		sprintf(szCmd8K_sub,"$%02XS%X7",wAddr,wSlot);
   		wRetVal_sub=Send_Receive_Cmd(wPort, szCmd8K_sub, szRec8K_sub, wTimeOut, wCheckSum,&wT);        
	} 	

   if(wFlag==1)
   {      
      	sprintf(szSend,"%s",szCmd8K);     
      	sprintf(szReceive,"%s",szRec8K);
   }
   if(wRetVal != NoError)
   {
   		return wRetVal;
   }
   if(szRec8K[0] != '>' ) 
   {
   		return ResultStrCheckError;
   }
   if(wReadMode==1)
   {
   		if(szRec8K_sub[0]!= '!') 
   		{
   			return ResultStrCheckError;
   		}
  }   

   if(wCheckSum==0) 
   {	//'>'+8*8=65  '>'+11*8 =89
   		if( strlen(szRec8K) != 65 && strlen(szRec8K) != 89 && strlen(szRec8K_sub) != 35 && strlen(szRec8K_sub) != 51)
   		{
   			return ResultStrCheckError;
   		}
   }
   else
   {
   		if( strlen(szRec8K) != 67 && strlen(szRec8K) != 91 && strlen(szRec8K_sub) != 37 && strlen(szRec8K_sub) != 53)
   		{
   			return ResultStrCheckError;
   		}
   }
   	if (strlen(szRec8K)==65 || strlen(szRec8K)==67) // hex format
   	{
   		for (i=1;i<65;i=i+8)  
   		{
   			valueStr[0]='0';
			valueStr[1]='x';
			strncpy(valueStr+2,szRec8K+i,8);
			valueStr[10]='\0';		
			sscanf(valueStr,"%08X",&val);
			LBuf[((i-1)/8)+9]=val;  
   		}
   	}
   	else if (strlen(szRec8K)==89 || strlen(szRec8K)==91)
   	{
   		for (i=1;i<89;i=i+11)
   		{
   			strncpy(valueStr,szRec8K+i,11);
			valueStr[11]='\0';		
			sscanf(valueStr,"%ld",&val);
			LBuf[((i-1)/11)+9]=val;  
   		}
   	} 
   	if(wReadMode==1)  // szRec8K_sub will be overflow value
   	{    	
   		if (strlen(szRec8K_sub)==35 || strlen(szRec8K_sub)==37) //hex format
   		{
   			for (i=3;i<35;i=i+4)
   			{
   				valueStr[0]='0';
				valueStr[1]='x';
				strncpy(valueStr,szRec8K_sub+i,4);
				valueStr[6]='\0';		
				sscanf(valueStr,"%04X",&val);
				LBuf[((i-1)/4)+17]=val;   				 	
   			}
   		}
   		else if (strlen(szRec8K_sub)==51 || strlen(szRec8K_sub)==53)
   		{
   			for (i=3;i<53;i=i+6)
   			{
   				strncpy(valueStr,szRec8K_sub+i,6);
				valueStr[6]='\0';		
				sscanf(valueStr,"%d",&val);
				LBuf[((i-1)/6)+17]=val;     			
			}						
   		}   		
   }	
   return(NoError);
}



 WORD CALLBACK ReadCounter_All(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char wPort,wFlag,wReadMode;
   char szCmd8K_sub[80],szRec8K_sub[80];
   WORD wAddr,wRetVal,wCheckSum,wTimeOut,wT,wRetVal_sub;   
   DWORD wID;
   WORD  wSlot,wChannel;  
   DWORD i;	
   char valueStr[256];
   unsigned long val;
   wID=dwBuf[2];
   
   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7080
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wChannel=(WORD)dwBuf[5];      // channel number
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   wSlot=(WORD)dwBuf[7];
   wReadMode =(char)dwBuf[8];	//wReadMode=0 read counter wReadMode= 1  read counter and overflow

   //---------------------- output ------------------------------------
                           // dwBuf[9]~dwBuf[16]= Counter 
                           // dwBuf[17]~dwBuf[24] =overflow                           
 	switch( wID)		
   {
		case 0x8080:
		break;
		default:
      	return(ModuleIdError);
   }

   	if( wChannel>7 )
   	{
    	return(InvalidateCounterNo);
    }   	
   	//***   #AASi read Counter 
	sprintf(szCmd8K,"#%02XS%X",wAddr,wSlot);
   	wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
	   
	if(wReadMode==1)
   	{
		sprintf(szCmd8K_sub,"$%02XS%X7",wAddr,wSlot);
   		wRetVal_sub=Send_Receive_Cmd(wPort, szCmd8K_sub, szRec8K_sub, wTimeOut, wCheckSum,&wT);        
	} 	

   if(wFlag==1)
   {
      
      	sprintf(szSend,"%s",szCmd8K);     
      	sprintf(szReceive,"%s",szRec8K);

   }
   if(wRetVal != NoError)
   {
   		return wRetVal;
   }
   if(szRec8K[0] != '>' ) 
   {
   		return ResultStrCheckError;
   }
   if(wReadMode==1)
   {
   		if(szRec8K_sub[0]!= '!') 
   		{
   			return ResultStrCheckError;
   		}
  	}   

   if(wCheckSum==0) 
   {	//'>'+8*8=65  '>'+11*8 =89
   		if( strlen(szRec8K) != 65 && strlen(szRec8K) != 89 && strlen(szRec8K_sub) != 35 && strlen(szRec8K_sub) != 51)
   		{
   			return ResultStrCheckError;
   		}
   }
   else
   {
   		if( strlen(szRec8K) != 67 && strlen(szRec8K) != 91 && strlen(szRec8K_sub) != 37 && strlen(szRec8K_sub) != 53)
   		{
   			return ResultStrCheckError;
   		}
   }
   	if (strlen(szRec8K)==65 || strlen(szRec8K)==67)
   	{
   		for (i=1;i<65;i=i+8)
   		{
   			valueStr[0]='0';
			valueStr[1]='x';
   			strncpy(valueStr,szRec8K+i,8);
			valueStr[10]='\0';		
			sscanf(valueStr,"%08X",&val);
			dwBuf[((i-1)/8)+9]=val;  
   		}
   	}
   	else if (strlen(szRec8K)==89 || strlen(szRec8K)==91)
   	{
   		for (i=1;i<89;i=i+11)
   		{
   			strncpy(valueStr,szRec8K+i,11);
			valueStr[11]='\0';		
			sscanf(valueStr,"%lu",&val);
			dwBuf[((i-1)/11)+9]=val;  
   		}
   	} 
   	if(wReadMode==1)  // szRec8K_sub will be overflow value
   	{    	
   		if (strlen(szRec8K_sub)==35 || strlen(szRec8K_sub)==37)
   		{
   			for (i=3;i<35;i=i+4)
   			{
   				valueStr[0]='0';
				valueStr[1]='x';
   				strncpy(valueStr,szRec8K_sub+i,4);
				valueStr[6]='\0';		
				sscanf(valueStr,"%04X",&val);
				dwBuf[((i-1)/4)+17]=val;   				 	
   			}
   		}
   		else if (strlen(szRec8K_sub)==51 || strlen(szRec8K_sub)==53)
   		{
   			for (i=3;i<53;i=i+6)
   			{
   				strncpy(valueStr,szRec8K_sub+i,6);
				valueStr[6]='\0';		
				sscanf(valueStr,"%lu",&val);
				dwBuf[((i-1)/6)+17]=val;     			
			}						
   		}   		
   }	
   return(NoError);
}


//------------------------- ReadFreq -----------------------
 WORD CALLBACK ReadFreq(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   
   char wPort,wFlag;
   WORD wAddr,wRetVal,wCheckSum,wTimeOut,wT;
   DWORD wID;
   WORD  wSlot,wChannel;   
   //WORD wRecStrLen;
   char valueStr[256];
   wID=dwBuf[2];
   
   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7080
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wChannel=(WORD)dwBuf[5];      // channel number
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   wSlot=(WORD)dwBuf[7];	//wSlot: Slot number 0 ~ 7
   
   //---------------------- output ------------------------------------
                           // dwBuf[9]= Counter or Frequency Value
                           
 	switch( wID)		
   {
		case 0x7080 :
		case 0x87082 :
		case 0x8080:
		case 0x8082://note this 8082 is 87082 on 8K MCU not i-8082

		break;
		default:
      	return(ModuleIdError);
   }
   if(wID==0x7080 || wID==0x87082 || wID==0x8082)
   {	
   		if( wChannel>1 )
   		{
       		return(InvalidateCounterNo);
       	}
   		else
   		{
   			//***   #AAN  read Counter/Frequency Value
			//sprintf(szCmd8K,"#%02X%X",wAddr,wChannel);
			if(wID==0x7080 || wID==0x87082)
				sprintf(szCmd8K,"#%02X%X",wAddr,wChannel);
			else
				sprintf(szCmd8K,"#%02XS%01XC%01X",wAddr,wSlot,wChannel);

   		}
   	}
   	else if (wID==0x8080)
   	{
   		if( wChannel>7 )
   		{
       		return(InvalidateCounterNo);
       	} 
       	  	
   		//***   #AASiCj  read Counter/Frequency Value
		sprintf(szCmd8K,"#%02XS%XC%X",wAddr,wSlot,wChannel);
   	}
   	else if (wID==0x8082)
   	{
   		if( wChannel>1 )
   		{
       		return(InvalidateCounterNo);
       	} 
       	  	
   		//***   #AASiCj  read Counter/Frequency Value
		sprintf(szCmd8K,"#%02XS%XC%X",wAddr,wSlot,wChannel);
   	}

   if(wFlag==1)
   {
      sprintf(szSend,"%s",szCmd8K);
      szReceive[0]=0;
   }
   
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1) 
   {     
   		strcpy(szReceive,szRec8K);
   }
   fBuf[0]=(float)0.0;

   if(wRetVal != NoError)
   {
   		return wRetVal;
   }
   if(szRec8K[0] != '>') 
   {
   		return ResultStrCheckError;
   }
   if(wID==0x7080 ||wID==0x87082 || wID==0x8082) // only hex format >FFFFFFFF
   {
   		if(wCheckSum==0) 
		{
   			if( strlen(szRec8K) != 9 && strlen(szRec8K) != 12) // 9:>FFFFFFFF  12 ;>+DDDDDDDDDD
   			{
   				return ResultStrCheckError;//strlen(szRec8K);//
   			}
		}
		else 
		{
   			if( strlen(szRec8K) != 11 && strlen(szRec8K) != 14) // 9:>FFFFFFFF  12 ;>+DDDDDDDDDD
   			{
   				return ResultStrCheckError;//strlen(szRec8K);//
   			}
		}			
		sprintf(valueStr,"%s",szRec8K+1);
		dwBuf[9]=(unsigned long)atol(valueStr);
	}
	else if(wID==0x8080)
	{
   		if(wCheckSum==0) 
   		{
   			if( strlen(szRec8K) != 9 && strlen(szRec8K) != 12) // 9:>FFFFFFFF  12 ;>+DDDDDDDDDD
   			{
   				return ResultStrCheckError;//strlen(szRec8K);//
   			}
		}
		else //wCheckSum==1
		{
   			if( strlen(szRec8K) != 11 && strlen(szRec8K) != 14)
   			{
   				return ResultStrCheckError;
   			}
		}

   		if (strlen(szRec8K)==9 || strlen(szRec8K)==11)
   		{
			sprintf(valueStr,"%s",szRec8K+1);    // >FFFFFFFF 
			dwBuf[9]=(unsigned long)atol(valueStr);
   		}
   		else if (strlen(szRec8K)==12 || strlen(szRec8K)==14)
   		{
			sprintf(valueStr,"%s",szRec8K+1);    // >DDDDDDDDDD 
			dwBuf[9]=(unsigned long)atol(valueStr);
		}		
   	}	
	return(NoError);
}

WORD CALLBACK ReadFreq_All(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char wPort,wFlag;  
   WORD wAddr,wRetVal,wCheckSum,wTimeOut,wT;   
   DWORD wID;
   WORD  wSlot,wChannel;   
   DWORD i;	
   unsigned long val;
   char valueStr[256];
   //WORD wRecStrLen;
   wID=dwBuf[2];
   
   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7080
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wChannel=(WORD)dwBuf[5];      // channel number
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   wSlot=(WORD)dwBuf[7];

   //---------------------- output ------------------------------------
                           // dwBuf[9]~dwBuf[16]= Freq 
                           
                           
		switch( wID)		
		{
			case 0x8080:
			break;
			default:
      		return(ModuleIdError);
		}

   		if( wChannel>7 )
   		{
    		return(InvalidateCounterNo);
		}   	
   		//***   #AASi read Frequency   	
 
		sprintf(szCmd8K,"#%02XS%X",wAddr,wSlot);
   		wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);

        if(wFlag==1)
        {   
           sprintf(szSend,"%s",szCmd8K);        
           sprintf(szReceive,"%s",szRec8K);
        }
        
        if(wRetVal != NoError)
        {
        		return wRetVal;
        }
        if(szRec8K[0] != '>' ) 
        {
        		return ResultStrCheckError;
        } 

   		if(wCheckSum==0) 
   		{
   			if( strlen(szRec8K) != 65 && strlen(szRec8K) != 89 )
   			{
   				return strlen(szRec8K);//ResultStrCheckError;
   			}
		}
		else  // checksum=1
		{
   			if( strlen(szRec8K) != 67 && strlen(szRec8K) != 91 )
   			{
   				return ResultStrCheckError;
   			}
		}
   		if (strlen(szRec8K)==65 || strlen(szRec8K)==67) //>000006430000063D0084CB2F008CCAD50085CA7A0084CA20008CC9C70084C96C
   		{
   			for (i=1;i<65;i=i+8)
   			{
   				strncpy(valueStr,szRec8K+i,8);
				valueStr[8]='\0';		
				sscanf(valueStr,"%lu",&val);
				dwBuf[((i-1)/8)+9]=val;   			
			}
   		}
   		else if (strlen(szRec8K)==89 || strlen(szRec8K)==91) //>+0000001597+0000001602+0008813660+0009337858+0008879015+0008813389+0009337588+0008813209
   		{
   			for (i=1;i<89;i=i+11)
   			{
   				strncpy(valueStr,szRec8K+i,11);
				valueStr[11]='\0';		
				sscanf(valueStr,"%lu",&val);
				dwBuf[((i-1)/11)+9]=val;
   			}
   		}	
		return(NoError);	
}        
       


/*-------- ClearCounter    Clear the counter---------*/
WORD CALLBACK  ClearCounter(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char wPort,wFlag;
   WORD wAddr,wRetVal,wCheckSum,wTimeOut,wT;   
   DWORD wID;
   WORD wSlot,wChannel;  
   WORD wRecStrLen;
   wID=dwBuf[2];
   
   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7080
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wChannel=(WORD)dwBuf[5];      // channel number
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   wSlot=(WORD)dwBuf[7];
   //------------------------------------------------------------------
                           
 	switch( wID)		
   {
		case 0x7080 :
		case 0x87082 :
		case 0x8080:
		case 0x8082:
		break;
		default:
      	return(ModuleIdError);
   }
   if(wID==0x7080 || wID==0x87082 || wID==0x8082)
   {	
   		if( wChannel>1 )
   		{
       		return(InvalidateCounterNo);
       	}
   		else
   		{
			if(wID==0x7080 || wID==0x87082)
				sprintf(szCmd8K,"$%02X6%01X",wAddr,wChannel);
			else
				sprintf(szCmd8K,"$%02XS%01XC%01X6",wAddr,wSlot,wChannel);

   			//***   $AA6N     Start/Stop Counting

   		}
   	}
   	else if (wID==0x8080)
   	{
   		if( wChannel>7 )
   		{
       		return(InvalidateCounterNo);
       	}   	
   		//***   $AASiCj6  Clear Counter/Frequency Value
		sprintf(szCmd8K,"$%02XS%01XC%01X6",wAddr,wSlot,wChannel);
   	}

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0)  wRecStrLen=3;  else  wRecStrLen=5;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   return(NoError);
}



/*-------- SetCounterStatus Start\Stop the counter---------*/
WORD CALLBACK  SetCounterStatus(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char wPort,wFlag;//,c1,c2;
   WORD wAddr,wRetVal,wCheckSum,wTimeOut,wT;   
   DWORD wID;
   WORD  wSlot,wChannel;
   WORD wStatus;
   WORD wRecStrLen;
   wID=dwBuf[2];
   
   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7080
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wChannel=(WORD)dwBuf[5];      // channel number
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   wSlot=(WORD)dwBuf[7];
   wStatus =(WORD)dwBuf[8];   // dwBuf[8]= Counter or Frequency Value
                           
 	switch( wID)		
   {
		case 0x7080 :
		case 0x87082 :
		case 0x8080:
		case 0x8082:
		break;
		default:
      	return(ModuleIdError);
   }
   if(wID==0x7080 || wID==0x87082 || wID==0x8082)
   {	
   		if( wChannel>1 )
   		{
       		return(InvalidateCounterNo);
       	}
   		else
   		{

   			//***   $AA5NS     Start/Stop Counting
			if(wID==0x7080 || wID==0x87082)
				sprintf(szCmd8K,"$%02X5%01X%01X",wAddr,wChannel,wStatus);
			else
				sprintf(szCmd8K,"$%02XS%01XC%01X5%01X",wAddr,wSlot,wChannel,wStatus);

   		}
   	}
   	else if (wID==0x8080)
   	{
   		if( wChannel>7 )
   		{
       		return(InvalidateCounterNo);
       	}   	
   		//***   $AASiCj5  read Counter/Frequency Value
   			//***   $AASiCj5s      Start/Stop Counting
		sprintf(szCmd8K,"$%02XS%01XC%01X5%01X",wAddr,wSlot,wChannel,wStatus);

   	}

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0)  wRecStrLen=3;  else  wRecStrLen=5;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   return(NoError);
}

/*-------- ReadCounterStatus S=0 Stop S=1 Start the counter---------*/
WORD CALLBACK  ReadCounterStatus(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   
   char wPort,wFlag;//,c1,c2;
   WORD wAddr,wRetVal,wCheckSum,wTimeOut,wT; 	
   DWORD wID,A;
   WORD  wSlot,wChannel; 
   WORD wRecStrLen;
   wID= dwBuf[2];
   
   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7080
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wChannel=(WORD)dwBuf[5];      // channel number
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   wSlot=(WORD)dwBuf[7];
   //----------------------- output -----------------------------------------
   						  // dwBuf[8]= Counter or Frequency Status
                           
 	switch( wID)		
   {
		case 0x7080 :
		case 0x87082 :
		case 0x8080:
		case 0x8082:
		break;
		default:
      	return(ModuleIdError);
   }
   if(wID==0x7080 || wID==0x87082 || wID==0x8082)
   {	
   		if( wChannel>1 )
   		{
       		return(InvalidateCounterNo);
       	}
   		else
   		{
			//***   $AA5N     Read Counter Status
			if(wID==0x7080 || wID==0x87082)
				sprintf(szCmd8K,"$%02X5%X",wAddr,wChannel);
			else
				sprintf(szCmd8K,"$%02XS%01XC%01X5",wAddr,wSlot,wChannel);
   		}
   	}
   	else if (wID==0x8080)
   	{
   		if( wChannel>7 )
   		{
       		return(InvalidateCounterNo);
       	}   	
   		//***   $AASiCj5  read Counter/Frequency Value
   			//***   $AASiCj5s      Start/Stop Counting
		sprintf(szCmd8K,"$%02XS%01XC%01X5",wAddr,wSlot,wChannel);
   	}

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(wCheckSum==0) wRecStrLen=4; else wRecStrLen=6;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   A=AsciiToHex(szRec8K[3]);

   dwBuf[8]=A;

   return(NoError);
}



  
  
  

 
 
 
 WORD CALLBACK ReadOutputAlarmState_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char wPort,wFlag,c1,c2;
   DWORD wID;
   WORD wAddr,wRetVal,wCheckSum,wTimeOut,wT;
   WORD wRecStrLen;

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7011/12/14/16
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   //  wCounter=dwBuf[5];      // Don't Care
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   //---------------------- output ------------------------------------
   //               Alarm State:
   // dwBuf(7):0       Disable  'for 87005 dwBuf(7) not define
   // dwBuf(7):1       Momentary
   // dwBuf(7):2       Latch
   //               Digital Output //for 87005 dwBuf(8) is the 6 channel DO output value
   // dwBuf(8):0       Bit:1 Disable  Bit 0: Disable
   // dwBuf(8):1       Bit:1 Disable  Bit 0: Enable
   // dwBuf(8):2       Bit:1 Enable   Bit 0: Disable
   // dwBuf(8):3       Bit:1 Enable   Bit 0: Enable

   switch (wID)
   {
       //case 0x7011 :
       //case 0x7012 :
       //case 0x7014 :
       case 0x87016 : 
	   case 0x87005 : //04/07/2005	   
	   break;
       default: return(ModuleIdError);
   }


   szCmd8K[0]='@';    // @AADI
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   szCmd8K[3]='D';
   szCmd8K[4]='I';
   szCmd8K[5]=0;

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      sprintf(szReceive,"%s",szRec8K);

   if(wRetVal != NoError) return wRetVal;

   //if(szRec[0] != '!') return ResultStrCheckError;
   if(wID==0x87005)
   {
		if(wCheckSum==0) 
			wRecStrLen=5; 
		else 
			wRecStrLen=7;
   }
   else
   {
		if(wCheckSum==0) 
			wRecStrLen=8; 
		else 
			wRecStrLen=10;
   }

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;
   if (wID==0x87005)
   {
		dwBuf[8]=AsciiToHex(szRec8K[3])*16+AsciiToHex(szRec8K[4]);
   }
   else
   {
		dwBuf[7]=szRec8K[3]-'0'; //!aasooii
		if( wID==0x87016 )
			dwBuf[8]= AsciiToHex(szRec8K[5]); //for 7016 wBuf[8] is only output value not alarm value
		else
			dwBuf[8]=(szRec8K[4]-'0')*2+(szRec8K[5]-'0');
   }

   return(NoError);
}



 WORD CALLBACK SetAlarmLimitValue_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,wFlag,c1,c2,channel,DOChannel,alarmType;
   DWORD   wID;
   WORD   wRecStrLen,wPoints,wAddr,wRetVal,wCheckSum,wTimeOut,wHiLo,wT,wRangeCode;
   float  fValue;
   char   OutCh[10];

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7011
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wHiLo=(WORD)dwBuf[5];         // 0: Lo Alarm    1: High Alarm
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   wRangeCode=(WORD)dwBuf[7];
   channel=(char)dwBuf[8] & 0x0f; //for 7005 AI channel
   DOChannel=(char)dwBuf[9] & 0x06;// for 7005 alarm map to DO channel
   alarmType=(char)dwBuf[10];    //alarmType=1: ==>'M' for momentary alarm 2==>'L' for latch alarm
   fValue=fBuf[0];        // Alarm Limit Value

   switch (wID)
   {
       //case 0x7011 :
       //case 0x7012 :
       //case 0x7014 :
       case 0x87016 :  
       case 0x87005 :
	   break;
       default: return(ModuleIdError);
   }

//   sprintf(OutCh,"%+07.2f",fValue);

   if( wID==87016 )
      if( wRangeCode>6 )
         return ExceedInputRange;

   switch( wRangeCode )
   {
      case 0:
           /*if( fValue>15.00 )
              return ExceedInputRange;
           if( fValue<-15.00 )
              return UnderInputRange;
           */
		   wPoints=3;
           break;
      case 1:
           /*if( fValue>50.00 )
              return ExceedInputRange;
           if( fValue<-50.00 )
              return UnderInputRange;*/
           wPoints=3;
           break;
      case 2:
           /*if( fValue>100.00 )
              return ExceedInputRange;
           if( fValue<-100.00 )
              return UnderInputRange;*/
           wPoints=2;
           break;
      case 3:
           /*if( fValue>500.00 )
              return ExceedInputRange;
           if( fValue<-500.00 )
              return UnderInputRange;*/
           wPoints=2;
           break;
      case 4:
           /*if( fValue>1.00 )
              return ExceedInputRange;
           if( fValue<-1.00 )
              return UnderInputRange;*/
           wPoints=4;
           break;
      case 5:
           /*if( fValue>2.50 )
              return ExceedInputRange;
           if( fValue<-2.50 )
              return UnderInputRange;*/
           wPoints=4;
           break;
      case 6:
           /*if( fValue>20.00 )
              return ExceedInputRange;
           if( fValue<-20.00 )
              return UnderInputRange;*/
           wPoints=3;
           break;
      case 7:
           /*if( fValue>500.00 )
              return ExceedInputRange;
           if( fValue<-500.00 )
              return UnderInputRange;*/
           wPoints=2;
           break;
      case 8:
           /*if( fValue>10.00 )
              return ExceedInputRange;
           if( fValue<-10.00 )
              return UnderInputRange;*/
           wPoints=3;
           break;
      case 9:
           /*if( fValue>5.00 )
              return ExceedInputRange;
           if( fValue<-5.00 )
              return UnderInputRange;*/
           wPoints=4;
           break;
      case 0x0A:
           /*if( fValue>1.00 )
              return ExceedInputRange;
           if( fValue<-1.00 )
              return UnderInputRange;*/
           wPoints=4;
           break;
      case 0x0B:
           /*if( fValue>500.00 )
              return ExceedInputRange;
           if( fValue<-500.00 )
              return UnderInputRange;*/
           wPoints=2;
           break;
      case 0x0C:
           /*if( fValue>150.00 )
              return ExceedInputRange;
           if( fValue<-150.00 )
              return UnderInputRange;*/
           wPoints=2;
           break;
      case 0x0D:
           /*if( fValue>20.00 )
              return ExceedInputRange;
           if( fValue<-20.00 )
              return UnderInputRange;*/
           wPoints=3;
           break;
      case 0x0E:
           /*if( fValue>760.00 )
              return ExceedInputRange;
           if( fValue<0.00 )
              return UnderInputRange;*/
           wPoints=3;
           break;
      case 0x0F:
           /*if( fValue>1320.00 )
              return ExceedInputRange;
           if( fValue<0.00 )
              return UnderInputRange;*/
           wPoints=1;
           break;
      case 0x10:
           /*if( fValue>400.00 )
              return ExceedInputRange;
           if( fValue<-100.00 )
              return UnderInputRange;*/
           wPoints=2;
           break;
      case 0x11:
           /*if( fValue>1000.00 )
              return ExceedInputRange;
           if( fValue<0.00 )
              return UnderInputRange;*/
           wPoints=1;
           break;
      case 0x12:
           /*if( fValue>1750.00 )
              return ExceedInputRange;
           if( fValue<500.00 )
              return UnderInputRange;*/
           wPoints=1;
           break;
      case 0x13:
           /*if( fValue>1750.00 )
              return ExceedInputRange;
           if( fValue<500.00 )
              return UnderInputRange;*/
           wPoints=1;
           break;
      case 0x14:
           /*if( fValue>1800.00 )
              return ExceedInputRange;
           if( fValue<500.00 )
              return UnderInputRange;*/
           wPoints=1;
           break;
      case 0x15:
           /*if( fValue>1300.00 )
              return ExceedInputRange;
           if( fValue<-270.00 )
              return UnderInputRange;*/
           wPoints=1;
           break;
      case 0x16:
           /*if( fValue>2320.00 )
              return ExceedInputRange;
           if( fValue<0.00 )
              return UnderInputRange;*/
           wPoints=1;
           break;
	  case 0x60: 
	  case 0x61:
	  case 0x62:
		  wPoints=2;
		  break;
       default: return(ModuleIdError);
   }

   switch( wPoints )
   {
      case 1:
         sprintf(OutCh,"%+07.1f",fValue);
         break;
      case 2:
         sprintf(OutCh,"%+07.2f",fValue);
         break;
      case 3:
         sprintf(OutCh,"%+07.3f",fValue);
         break;
      case 4:
         sprintf(OutCh,"%+07.4f",fValue);
         break;
      default: return(ModuleIdError);
   }
	
   if(wID==0x87005)
   {
		szCmd8K[0]='@';    // @AALO(data): set low alarm limit
		c2=(char)(wAddr&0x0f);
		wAddr=wAddr/16;
		c1=(char)(wAddr&0x0f);
		szCmd8K[1] = HexToAscii(c1);
		szCmd8K[2] = HexToAscii(c2);
		if( wHiLo==0 )   //  Low Alarm
		{
			szCmd8K[3]='L';
			szCmd8K[4]='O';
		}
		else
		{
			szCmd8K[3]='H';
			szCmd8K[4]='I';
		}

		szCmd8K[5]=OutCh[0];
		szCmd8K[6]=OutCh[1];
		szCmd8K[7]=OutCh[2];
		szCmd8K[8]=OutCh[3];
		szCmd8K[9]=OutCh[4];
		szCmd8K[10]=OutCh[5];
		szCmd8K[11]=OutCh[6];
		szCmd8K[12]='C';
		szCmd8K[13]=HexToAscii(channel);

		if (alarmType==1)
			szCmd8K[14]='M';
		else if (alarmType==2)
			szCmd8K[14]='L';
		
		szCmd8K[15]='O';
		szCmd8K[16]=HexToAscii(DOChannel);
		szCmd8K[17]=0;
   }
   else
   {
                    // @AAHI(data): set high alarm limit
		szCmd8K[0]='@';    // @AALO(data): set low alarm limit
		c2=(char)(wAddr&0x0f);
		wAddr=wAddr/16;
		c1=(char)(wAddr&0x0f);
		szCmd8K[1] = HexToAscii(c1);
		szCmd8K[2] = HexToAscii(c2);
		if( wHiLo==0 )   //  Low Alarm
		{
			szCmd8K[3]='L';
			szCmd8K[4]='O';
		}
		else
		{
			szCmd8K[3]='H';
			szCmd8K[4]='I';
		}

		szCmd8K[5]=OutCh[0];
		szCmd8K[6]=OutCh[1];
		szCmd8K[7]=OutCh[2];
		szCmd8K[8]=OutCh[3];
		szCmd8K[9]=OutCh[4];
		szCmd8K[10]=OutCh[5];
		szCmd8K[11]=OutCh[6];
		szCmd8K[12]=0;
   }

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=3; else wRecStrLen=5;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   return(NoError);
}



/*-------- 87016 Read Hi/Lo Alarm Limit Value ---------*/
 WORD CALLBACK ReadAlarmLimitValue_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,wFlag,c1,c2,channel;
   WORD   i,wAddr,wRetVal,wCheckSum,wTimeOut,wHiLo,wT;
   WORD   wRecStrLen;
   DWORD   wID;
   //float  fValue;
   char   Buffer[10];

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7011
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wHiLo=(WORD)dwBuf[5];         // 0: Lo Alarm    1: High Alarm
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   channel=(char)dwBuf[7] & 0x0f;

   //---------------------- output -------------------------------------
   //fValue=fBuf[0];      // Alarm Limit Value
   //dwBuf[8]              // alarm Type 0: Disable 1: momentary 2: latch
   //dwBuf[9]			  // alarm to DO channel

   switch (wID)
   {
    //   case 0x7011 :
    //   case 0x7012 :
    //   case 0x7014 :
       case 0x87016 : 
	   case 0x87005:
	   break;
       default: return(ModuleIdError);
   }

   if(wID==0x87005)
   {
	   // @AARH(data): read high alarm limit
		szCmd8K[0]='@';    // @AARL(data): read low  alarm limit
		c2=(char)(wAddr&0x0f);
		wAddr=wAddr/16;
		c1=(char)(wAddr&0x0f);
		szCmd8K[1] = HexToAscii(c1);
		szCmd8K[2] = HexToAscii(c2);
		szCmd8K[3]='R';
		if( wHiLo==0 )   //  Low Alarm
		{			
			szCmd8K[4]='L';
		}
		else
		{		
			szCmd8K[4]='H';
		}
		szCmd8K[5]=HexToAscii(channel);
		szCmd8K[6]=0;
   }
   else
   {
	   // @AARH(data): read high alarm limit
		szCmd8K[0]='@';    // @AARL(data): read low  alarm limit
		c2=(char)(wAddr&0x0f);
		wAddr=wAddr/16;
		c1=(char)(wAddr&0x0f);
		szCmd8K[1] = HexToAscii(c1);
		szCmd8K[2] = HexToAscii(c2);
		szCmd8K[3]='R';
		if( wHiLo==0 )   //  Low Alarm
		{			
			szCmd8K[4]='L';
		}
		else
		{		
			szCmd8K[4]='H';
		}
		szCmd8K[5]=0;
   }

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;
   if(wID==0x87005)
   {
		if(wCheckSum==0) wRecStrLen=13; else wRecStrLen=15;
   }
   else
   {
	   if(wCheckSum==0) wRecStrLen=10; else wRecStrLen=12;
   }

//   if( strlen(szRec) != wRecStrLen) return ResultStrCheckError;

   for(i=0; i<7; i++)
       Buffer[i]=szRec8K[i+3];
   Buffer[7]=0;
   fBuf[0]=(float) atof(Buffer);
   dwBuf[8]=szRec8K[10]; //alarm type
   dwBuf[9]=szRec8K[12]; //alarm to DO map

   return(NoError);
}

/*-------- 7011/7012/7014/7016 Read Event Counter --------*/
 WORD CALLBACK ReadEventCounter_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,wFlag,c1,c2;
   WORD   wAddr,wRetVal,wCheckSum,wTimeOut,wT;
   WORD   wRecStrLen;
   DWORD   wID;
   int    i;
   char   szTemp[6];

   //---------------------- input -----------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7011
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100   
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   //---------------------- output ----------------------------------
   // wCount=wBuf[7];     // The Event Counter Value

   switch (wID)
   {
       //case 0x7011 :
       //case 0x7012 :
       //case 0x7014 :
       case 0x87016 :  break;
       default: return(ModuleIdError);
   }

   szCmd8K[0]='@';    // @AARE
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   szCmd8K[3]='R';
   szCmd8K[4]='E';
   szCmd8K[5]=0;

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=8; else wRecStrLen=10;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   for(i=0; i<5; i++)
   {
      szTemp[i]=szRec8K[i+3];
   }   
   szTemp[5]=0;
   dwBuf[7]=(WORD)(atoi(szTemp));

   return(NoError);
}


/*-------- 7011/7012/7014/7016 Clear Event Counter --------*/
 WORD CALLBACK ClearEventCounter_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,wFlag,c1,c2;
   WORD   wAddr,wRetVal,wCheckSum,wTimeOut,wT;
   WORD   wRecStrLen;
   DWORD   wID;

   //---------------------- input -----------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7011
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100   
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string

   switch (wID)
   {
       //case 0x7011 :
       //case 0x7012 :
       //case 0x7014 :
       case 0x87016 :  break;
       default: return(ModuleIdError);
   }

   szCmd8K[0]='@';    // @AACE
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   szCmd8K[3]='C';
   szCmd8K[4]='E';
   szCmd8K[5]=0;

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=3; else wRecStrLen=5;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   return(NoError);
}


 /*-------- 7011/7012/7014/7016 Enable Alarm ---------*/
 WORD CALLBACK EnableAlarm_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,wFlag,c1,c2;
   DWORD wID;
   WORD   wAddr,wRetVal,wCheckSum,wTimeOut,wAlarmMode,wT;
   WORD   wRecStrLen;

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7011
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wAlarmMode=(WORD)dwBuf[5];    // 0: Momentary,  1: Latch
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string

   switch (wID)
   {
       //case 0x7011 :
       //case 0x7012 :
       //case 0x7014 :
       case 0x7016 :  break;
       default: return(ModuleIdError);
   }

   szCmd8K[0]='@';    // @AAEAT
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   szCmd8K[3]='E';
   szCmd8K[4]='A';
   if( wAlarmMode==0 )
      szCmd8K[5]='M';
   else
      szCmd8K[5]='L';
   szCmd8K[6]=0;

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=3; else wRecStrLen=5;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   return(NoError);
}


/*-------- 7011/7012/7014/7016/7005 Disable Alarm ---------*/
 WORD CALLBACK DisableAlarm_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,channel,wFlag,c1,c2; //alarmMode:H:high alarm and L:low alarm
   WORD   wAddr,wRetVal,wCheckSum,wTimeOut,wT;
   DWORD   wID;
   WORD   wRecStrLen,wHiLo;
   //float  fValue;
   //char   OutCh[10];

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7011
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wHiLo = (WORD)dwBuf[5];   // wHiLo:1 : H:high alarm and 0: L:low alarm
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   channel=(char)dwBuf[7] & 0x0f ;
   switch (wID)
   {
       //case 0x7011 :
       //case 0x7012 :
       //case 0x7014 :
       case 0x87016 :  
	   case 0x87005 :
	   break;
       default: return(ModuleIdError);
   }
   if(wID==0x87005)//07/10/2004
   {
		szCmd8K[0]='@';    // @AADHCi @AADLCi
		c2=(char)(wAddr&0x0f);
		wAddr=wAddr/16;
		c1=(char)(wAddr&0x0f);
		szCmd8K[1] = HexToAscii(c1);
		szCmd8K[2] = HexToAscii(c2);
		szCmd8K[3]='D';
		if( wHiLo==0 )   //  Low Alarm
		{
			szCmd8K[4]='L';
		}
		else
		{
			szCmd8K[4]='H';		
		}
		szCmd8K[5]='C';
		szCmd8K[6]=HexToAscii(channel);
		szCmd8K[7]=0;
   }
   else
   {
		szCmd8K[0]='@';    // @AADA
		c2=(char)(wAddr&0x0f);
		wAddr=wAddr/16;
		c1=(char)(wAddr&0x0f);
		szCmd8K[1] = HexToAscii(c1);
		szCmd8K[2] = HexToAscii(c2);
		szCmd8K[3]='D';
		szCmd8K[4]='A';
		szCmd8K[5]=0;
   }

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=3; else wRecStrLen=5;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   return(NoError);
}

/*-------- 7011/7012/7014/7016/7005 Clear Latch Alarm ---------*/
 WORD CALLBACK ClearLatchAlarm_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,wFlag,channel,c1,c2;
   WORD   wAddr,wRetVal,wCheckSum,wTimeOut,wT;
   DWORD   wID;
   WORD   wRecStrLen,wHiLo;

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7011
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wHiLo = (WORD)dwBuf[5];   // alarmMode:H:high alarm and L:low alarm
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   channel=(char)dwBuf[7] & 0x0f ;

   switch (wID)
   {
       //case 0x7011 :
       //case 0x7012 :
       //case 0x7014 :
       case 0x87016 :
	   case 0x87005 :
	   break;
       default: return(ModuleIdError);
   }
   if(wID==0x87005)
   {
		szCmd8K[0]='@';    // @AACA
		c2=(char)(wAddr&0x0f);
		wAddr=wAddr/16;
		c1=(char)(wAddr&0x0f);
		szCmd8K[1] = HexToAscii(c1);
		szCmd8K[2] = HexToAscii(c2);
		szCmd8K[3]='C';
		if( wHiLo==0 )   //  Low Alarm
		{
			szCmd8K[4]='L';
		}
		else
		{
			szCmd8K[4]='H';		
		}
		szCmd8K[5]='C';
		szCmd8K[6]=HexToAscii(channel);
		szCmd8K[7]=0;
   }
   else
   {
		szCmd8K[0]='@';    // @AACA
		c2=(char)(wAddr&0x0f);
		wAddr=wAddr/16;
		c1=(char)(wAddr&0x0f);
		szCmd8K[1] = HexToAscii(c1);
		szCmd8K[2] = HexToAscii(c2);
		szCmd8K[3]='C';
		szCmd8K[4]='A';
		szCmd8K[5]=0;
   }

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=3; else wRecStrLen=5;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   return(NoError);
}





  WORD CALLBACK SetupLinearMapping_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,wFlag,c1,c2;
   WORD   wAddr,wRetVal,wCheckSum,wTimeOut,wHiLo,wT,wRangeCode;
   WORD   wRecStrLen,wPoints;
   DWORD   wID;
   float  fSourceLow,fSourceHigh,fTargetLow,fTargetHigh;
   char   OutCh[20];

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7014, 7016
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wHiLo=(WORD)dwBuf[5];         // 0: Lo Alarm    1: High Alarm
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   wRangeCode=(WORD)dwBuf[7];
   //fValue=fBuf[0];      // Alarm Limit Value
   fSourceLow  = fBuf[0];
   fSourceHigh = fBuf[1];
   fTargetLow  = fBuf[2];
   fTargetHigh = fBuf[3];

   switch (wID)
   {
       //case 0x7014 :
       case 0x87016 :  break;
       default: return(ModuleIdError);
   }

//   sprintf(OutCh,"%+07.2f",fValue);

   if( wID==87016 )
      if( wRangeCode>6 )
         return ExceedInputRange;

   if( fSourceLow>fSourceHigh )
      return  DataError;

   switch( wRangeCode )
   {
      case 0:
           if( fSourceHigh>15.00 )
              return ExceedInputRange;
           if( fSourceLow<-15.00 )
              return UnderInputRange;
           wPoints=3;
           break;
      case 1:
           if( fSourceHigh>50.00 )
              return ExceedInputRange;
           if( fSourceLow<-50.00 )
              return UnderInputRange;
           wPoints=3;
           break;
      case 2:
           if( fSourceHigh>100.00 )
              return ExceedInputRange;
           if( fSourceLow<-100.00 )
              return UnderInputRange;
           wPoints=2;
           break;
      case 3:
           if( fSourceHigh>500.00 )
              return ExceedInputRange;
           if( fSourceLow<-500.00 )
              return UnderInputRange;
           wPoints=2;
           break;
      case 4:
           if( fSourceHigh>1.00 )
              return ExceedInputRange;
           if( fSourceLow<-1.00 )
              return UnderInputRange;
           wPoints=4;
           break;
      case 5:
           if( fSourceHigh>2.50 )
              return ExceedInputRange;
           if( fSourceLow<-2.50 )
              return UnderInputRange;
           wPoints=4;
           break;
      case 6:
           if( fSourceHigh>20.00 )
              return ExceedInputRange;
           if( fSourceLow<-20.00 )
              return UnderInputRange;
           wPoints=3;
           break;
      case 7:
           if( fSourceHigh>500.00 )
              return ExceedInputRange;
           if( fSourceLow<-500.00 )
              return UnderInputRange;
           wPoints=2;
           break;
      case 8:
           if( fSourceHigh>10.00 )
              return ExceedInputRange;
           if( fSourceLow<-10.00 )
              return UnderInputRange;
           wPoints=3;
           break;
      case 9:
           if( fSourceHigh>5.00 )
              return ExceedInputRange;
           if( fSourceLow<-5.00 )
              return UnderInputRange;
           wPoints=4;
           break;
      case 0x0A:
           if( fSourceHigh>1.00 )
              return ExceedInputRange;
           if( fSourceLow<-1.00 )
              return UnderInputRange;
           wPoints=4;
           break;
      case 0x0B:
           if( fSourceHigh>500.00 )
              return ExceedInputRange;
           if( fSourceLow<-500.00 )
              return UnderInputRange;
           wPoints=2;
           break;
      case 0x0C:
           if( fSourceHigh>150.00 )
              return ExceedInputRange;
           if( fSourceLow<-150.00 )
              return UnderInputRange;
           wPoints=2;
           break;
      case 0x0D:
           if( fSourceHigh>20.00 )
              return ExceedInputRange;
           if( fSourceLow<-20.00 )
              return UnderInputRange;
           wPoints=3;
           break;
      case 0x0E:
           if( fSourceHigh>760.00 )
              return ExceedInputRange;
           if( fSourceLow<0.00 )
              return UnderInputRange;
           wPoints=3;
           break;
      case 0x0F:
           if( fSourceHigh>1320.00 )
              return ExceedInputRange;
           if( fSourceLow<0.00 )
              return UnderInputRange;
           wPoints=1;
           break;
      case 0x10:
           if( fSourceHigh>400.00 )
              return ExceedInputRange;
           if( fSourceLow<-100.00 )
              return UnderInputRange;
           wPoints=2;
           break;
      case 0x11:
           if( fSourceHigh>1000.00 )
              return ExceedInputRange;
           if( fSourceLow<0.00 )
              return UnderInputRange;
           wPoints=1;
           break;
      case 0x12:
           if( fSourceHigh>1750.00 )
              return ExceedInputRange;
           if( fSourceLow<500.00 )
              return UnderInputRange;
           wPoints=1;
           break;
      case 0x13:
           if( fSourceHigh>1750.00 )
              return ExceedInputRange;
           if( fSourceLow<500.00 )
              return UnderInputRange;
           wPoints=1;
           break;
      case 0x14:
           if( fSourceHigh>1800.00 )
              return ExceedInputRange;
           if( fSourceLow<500.00 )
              return UnderInputRange;
           wPoints=1;
           break;
      case 0x15:
           if( fSourceHigh>1300.00 )
              return ExceedInputRange;
           if( fSourceLow<-270.00 )
              return UnderInputRange;
           wPoints=1;
           break;
      case 0x16:
           if( fSourceHigh>2320.00 )
              return ExceedInputRange;
           if( fSourceLow<0.00 )
              return UnderInputRange;
           wPoints=1;
           break;
       default: return(ModuleIdError);
   }

   switch( wPoints )
   {
      case 1:
         sprintf(OutCh,"%+07.1f%+07.1f",fSourceLow,fSourceHigh);
         break;
      case 2:
         sprintf(OutCh,"%+07.2f%+07.2f",fSourceLow,fSourceHigh);
         break;
      case 3:
         sprintf(OutCh,"%+07.3f%+07.3f",fSourceLow,fSourceHigh);
         break;
      case 4:
         sprintf(OutCh,"%+07.4f%+07.4f",fSourceLow,fSourceHigh);
         break;
      default: return(ModuleIdError);
   }


  
    szCmd8K[0]='@';
    c2=(char)(wAddr&0x0f);
    wAddr=wAddr/16;
    c1=(char)(wAddr&0x0f);
    szCmd8K[1] = HexToAscii(c1);
	szCmd8K[2] = HexToAscii(c2);
	szCmd8K[3]='6';
   
   szCmd8K[4]=OutCh[0];
   szCmd8K[5]=OutCh[1];
   szCmd8K[6]=OutCh[2];
   szCmd8K[7]=OutCh[3];
   szCmd8K[8]=OutCh[4];
   szCmd8K[9]=OutCh[5];
   szCmd8K[10]=OutCh[6];

   szCmd8K[11]=OutCh[7];
   szCmd8K[12]=OutCh[8];
   szCmd8K[13]=OutCh[9];
   szCmd8K[14]=OutCh[10];
   szCmd8K[15]=OutCh[11];
   szCmd8K[16]=OutCh[12];
   szCmd8K[17]=OutCh[13];
   szCmd8K[18]=0;

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=3; else wRecStrLen=5;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   Sleep(100);
   /******************************************************************/
   if( fTargetLow>19999.0 )
      return ExceedInputRange;
   else if( fTargetLow>10000.0 )
      sprintf(OutCh,"%+07.1f",fTargetLow);
   else if( fTargetLow>1000.0 )
      sprintf(OutCh,"%+07.1f",fTargetLow);
   else if( fTargetLow>100.0 )
      sprintf(OutCh,"%+07.2f",fTargetLow);
   else if( fTargetLow>10.0 )
      sprintf(OutCh,"%+07.3f",fTargetLow);
   else if( fTargetLow>1.0 )
      sprintf(OutCh,"%+07.4f",fTargetLow);
   else if( fTargetLow>0.0 )
      sprintf(OutCh,"%+07.5f",fTargetLow);
   else if( fTargetLow>-1.0 )
      sprintf(OutCh,"%+07.4f",fTargetLow);
   else if( fTargetLow>-10.0 )
      sprintf(OutCh,"%+07.3f",fTargetLow);
   else if( fTargetLow>-100.0 )
      sprintf(OutCh,"%+07.2f",fTargetLow);
   else if( fTargetLow>-1000.0 )
      sprintf(OutCh,"%+07.1f",fTargetLow);
   else if( fTargetLow>-19999.0 )
      sprintf(OutCh,"%+07.1f",fTargetLow);
   else
      return UnderInputRange;

   if( fTargetHigh>19999.0 )
      return ExceedInputRange;
   else if( fTargetHigh>10000.0 )
      sprintf(OutCh+7,"%+07.1f",fTargetHigh);
   else if( fTargetHigh>1000.0 )
      sprintf(OutCh+7,"%+07.1f",fTargetHigh);
   else if( fTargetHigh>100.0 )
      sprintf(OutCh+7,"%+07.2f",fTargetHigh);
   else if( fTargetHigh>10.0 )
      sprintf(OutCh+7,"%+07.3f",fTargetHigh);
   else if( fTargetHigh>1.0 )
      sprintf(OutCh+7,"%+07.4f",fTargetHigh);
   else if( fTargetHigh>0.0 )
      sprintf(OutCh+7,"%+07.5f",fTargetHigh);
   else if( fTargetHigh>-1.0 )
      sprintf(OutCh+7,"%+07.4f",fTargetHigh);
   else if( fTargetHigh>-10.0 )
      sprintf(OutCh+7,"%+07.3f",fTargetHigh);
   else if( fTargetHigh>-100.0 )
      sprintf(OutCh+7,"%+07.2f",fTargetHigh);
   else if( fTargetHigh>-1000.0 )
      sprintf(OutCh+7,"%+07.1f",fTargetHigh);
   else if( fTargetHigh>-19999.0 )
      sprintf(OutCh+7,"%+07.1f",fTargetHigh);
   else
      return UnderInputRange;

   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   
   szCmd8K[0]='@';
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   szCmd8K[3]='7';
   
   szCmd8K[4]=OutCh[0];
   szCmd8K[5]=OutCh[1];
   szCmd8K[6]=OutCh[2];
   szCmd8K[7]=OutCh[3];
   szCmd8K[8]=OutCh[4];
   szCmd8K[9]=OutCh[5];
   szCmd8K[10]=OutCh[6];

   szCmd8K[11]=OutCh[7];
   szCmd8K[12]=OutCh[8];
   szCmd8K[13]=OutCh[9];
   szCmd8K[14]=OutCh[10];
   szCmd8K[15]=OutCh[11];
   szCmd8K[16]=OutCh[12];
   szCmd8K[17]=OutCh[13];
   szCmd8K[18]=0;

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=3; else wRecStrLen=5;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   Sleep(100);

   return(NoError);
}

/*-------- Enable Linear Mapping for 7014/7016 ---------*/
 WORD CALLBACK EnableLinearMapping_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,wFlag,c1,c2;
   WORD   wAddr,wRetVal,wCheckSum,wTimeOut,wT;
   WORD   wRecStrLen;
   DWORD   wID;
   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7014, 0x7016
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   // wBuf[5] don't care
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string

   switch (wID)
   {
       //case 0x7014 :
       case 0x87016 :  break;
       default: return(ModuleIdError);
   }

  
   szCmd8K[0]='@';    // @AAAV
   c2=(char)(wAddr&0x0f);
   wAddr=wAddr/16;
   c1=(char)(wAddr&0x0f);
   szCmd8K[1] = HexToAscii(c1);
   szCmd8K[2] = HexToAscii(c2);
   szCmd8K[3]='A';
   szCmd8K[4]='1';
   szCmd8K[5]=0;
   

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=3; else wRecStrLen=5;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   return(NoError);
}

/*-------- Disable Linear Mapping for 7014/7016 ---------*/
 WORD CALLBACK DisableLinearMapping_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,wFlag,c1,c2;
   WORD   wAddr,wRetVal,wCheckSum,wTimeOut,wT;
   DWORD   wID;
   WORD   wRecStrLen;

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7014, 0x7016
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   // wBuf[5] don't care
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string

   switch (wID)
   {       
       case 0x87016 :  break;
       default: return(ModuleIdError);
   }

  
    szCmd8K[0]='@';    // @AAAV
    c2=(char)(wAddr&0x0f);
    wAddr=wAddr/16;
	c1=(char)(wAddr&0x0f);
    szCmd8K[1] = HexToAscii(c1);
    szCmd8K[2] = HexToAscii(c2);
    szCmd8K[3]='A';
    szCmd8K[4]='0';
    szCmd8K[5]=0;
   

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=3; else wRecStrLen=5;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   return(NoError);
}

/*-------- reading the linear mapping status for 7014/7016 --------*/
 WORD CALLBACK ReadLinearMappingStatus_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,wFlag,c1,c2;
   WORD   wAddr,wRetVal,wID,wCheckSum,wTimeOut,wT;
   WORD   wRecStrLen;

   //---------------------- input -----------------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=(WORD)dwBuf[2];           // module ID: 0x7014, 0x7016
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100  
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string

   switch (wID)
   {       
       case 0x87016 :  wID=1;  break;
       default: return(ModuleIdError);
   }

  
      szCmd8K[0]='@';
      c2=(char)(wAddr&0x0f);
      wAddr=wAddr/16;
      c1=(char)(wAddr&0x0f);
      szCmd8K[1] = HexToAscii(c1);
      szCmd8K[2] = HexToAscii(c2);
      szCmd8K[3]='A';
      szCmd8K[4]=0;
  
   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=4; else wRecStrLen=6;

   if( strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   dwBuf[5]=szRec8K[3]-'0';

   return(NoError);
}

/*----- Reading Source Value of Linear Mapping for 87016 -----*/
 WORD CALLBACK ReadSourceValueOfLM_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,wFlag,c1,c2,Buffer[10];
   WORD   wAddr,wRetVal,i,j,wCheckSum,wTimeOut,wT;
   DWORD   wID;
   WORD   wRecStrLen;

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];  // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];        // module address: 0x00 to 0xFF
   wID=dwBuf[2];          // module ID: 0x7014/16
   wCheckSum=(WORD)dwBuf[3];    // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];     // TimeOut constant: normal=100
   wFlag=(char)dwBuf[6];  // flag: 0=no save, 1=save send/receive string
   //---------------------- output ------------------------------------
   // fBuf[0]= Low Source Value
   // fBuf[1]= High Source Value

   switch (wID)
   {      
      case 0x87016 : break;
      default: return(ModuleIdError);
   }

   
      szCmd8K[0]='@';           //@AA6
      c2=(char)(wAddr&0x0f);
      wAddr=wAddr/16;
      c1=(char)(wAddr&0x0f);
      szCmd8K[1] = HexToAscii(c1);
      szCmd8K[2] = HexToAscii(c2);
      szCmd8K[3] = '6';
      szCmd8K[4]=0;
   

   if( wFlag==1 )
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   for (j=0; j<7; j++) fBuf[j]=(float)1.1;
   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=17; else wRecStrLen=19;

   if(strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   for(i=0; i<7; i++)
      Buffer[i]=szRec8K[i+3];
   Buffer[7]=0;
   fBuf[0]=(float)atof(Buffer);

   for(i=0; i<7; i++)
      Buffer[i]=szRec8K[i+10];
   Buffer[7]=0;
   fBuf[1]=(float)atof(Buffer);

   return(NoError);
}

/*----- Reading Target Value of Linear Mapping for 7014/7016 -----*/
 WORD CALLBACK ReadTargetValueOfLM_87K(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])
{
   char   wPort,wFlag,c1,c2,Buffer[10];//
   WORD   wAddr,wRetVal,wCheckSum,wTimeOut,i,j,wT;
   
   DWORD   wID;
   WORD   wRecStrLen;

   //---------------------- input -------------------------------------
   wPort=(char)dwBuf[0];  // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];        // module address: 0x00 to 0xFF
   wID=dwBuf[2];          // module ID: 0x7014/16
   wCheckSum=(WORD)dwBuf[3];    // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];     // TimeOut constant: normal=100
   wFlag=(char)dwBuf[6];  // flag: 0=no save, 1=save send/receive string
   //---------------------- output ------------------------------------
   // fBuf[0]= Low Target Value
   // fBuf[1]= High Target Value

   switch (wID)
   {
     
      case 0x87016 : break;
      default: return(ModuleIdError);
   }

   
      szCmd8K[0]='@';           //@AA7
      c2=(char)(wAddr&0x0f);
      wAddr=wAddr/16;
      c1=(char)(wAddr&0x0f);
      szCmd8K[1] = HexToAscii(c1);
      szCmd8K[2] = HexToAscii(c2);
      szCmd8K[3] = '7';
      szCmd8K[4]=0;
   

   if( wFlag==1 )
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   for (j=0; j<7; j++) fBuf[j]=(float)0.0;
   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=17; else wRecStrLen=19;

   if(strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   for(i=0; i<7; i++)
      Buffer[i]=szRec8K[i+3];
   Buffer[7]=0;
   fBuf[0]=(float)atof(Buffer);

   for(i=0; i<7; i++)
      Buffer[i]=szRec8K[i+10];
   Buffer[7]=0;
   fBuf[1]=(float)atof(Buffer);

   return(NoError);
}

 WORD CALLBACK DigitalOut_87016(DWORD dwBuf[], float fBuf[],
        char szSend[], char szReceive[])//def @17
{
   char  wPort,wFlag,c1,c2; //,A,B,C,D;
   WORD  wAddr,wRetVal,wData,wCheckSum,wTimeOut,wT;
   DWORD wID;
   WORD  wRecStrLen,wWhichBits;
   //UCHAR OutData[4];

   //---------------------- input ---------------------------
   wPort=(char)dwBuf[0];   // RS-232 port number: 1/2/3/4/..../255
   wAddr=(WORD)dwBuf[1];         // module address: 0x00 to 0xFF
   wID=dwBuf[2];           // module ID: 0x7016
   wCheckSum=(WORD)dwBuf[3];     // checksum: 0=disable, 1=enable
   wTimeOut=(WORD)dwBuf[4];      // TimeOut constant: normal=100
   wData=(WORD)dwBuf[5];         // 2-bit digital data to output
   wFlag=(char)dwBuf[6];   // flag: 0=no save, 1=save send/receive string
   wWhichBits=(WORD)dwBuf[7];    // 0: first two bits,  1: last two bits
   //---------------------- output -----------------------
                        // void
   switch (wID)
   {
        case 0x87016:  //  @AADO0?  for Bit0, Bit1
                      //  @AADO1?  for Bit2, Bit3
                      break;
        default: return(ModuleIdError);
   }


   // 7016,  @AADO0?,  @AADO1?
   if( wData>3 )
      return DataError;

   if( wWhichBits==0 )  // first 2 bits,  @AADO0?
   {
      //--- Bit0, Bit1 ---
      szCmd8K[0]='@';
      c2=(char)(wAddr&0x0f);
      wAddr=wAddr/16;
      c1=(char)(wAddr&0x0f);
      szCmd8K[1] = HexToAscii(c1);
      szCmd8K[2] = HexToAscii(c2);
      szCmd8K[3]='D';
      szCmd8K[4]='O';
      szCmd8K[5]='0';
      szCmd8K[6]=wData+'0';
      szCmd8K[7]=0;
   }
   else   // last 2 bits,  @AADO0?
   {
      //--- Bit2, Bit3 ---
      szCmd8K[0]='@';
      c2=(char)(wAddr&0x0f);
      wAddr=wAddr/16;
      c1=(char)(wAddr&0x0f);
      szCmd8K[1] = HexToAscii(c1);
      szCmd8K[2] = HexToAscii(c2);
      szCmd8K[3]='D';
      szCmd8K[4]='O';
      szCmd8K[5]='1';
      szCmd8K[6]=wData+'0';
      szCmd8K[7]=0;
   }

   if(wFlag==1)
   {
      strcpy(szSend,szCmd8K);
      szReceive[0]=0;
   }
   wRetVal=Send_Receive_Cmd(wPort, szCmd8K, szRec8K, wTimeOut, wCheckSum,&wT);
   if(wFlag==1)      strcpy(szReceive,szRec8K);

   if(wRetVal != NoError) return wRetVal;

   if(szRec8K[0] != '!') return ResultStrCheckError;

   if(wCheckSum==0) wRecStrLen=3; else wRecStrLen=5;

   if(strlen(szRec8K) != wRecStrLen) return ResultStrCheckError;

   return(NoError);
}
